<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Embed
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Embed
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Embed_Parser_Abstract implements Core_Embed_Parser_Interface
{
    /**
     * @var Zend_Http_Client
     */
    protected $_httpClient;

    /**
     * @param Zend_Http_Client $httpClient
     *
     * @return \Core_Embed_Parser_Abstract
     */
    public function setHttpClient(Zend_Http_Client $httpClient)
    {
        $this->_httpClient = $httpClient;
        return $this;
    }

    /**
     * @return Zend_Http_Client
     */
    public function getHttpClient()
    {
        if (null === $this->_httpClient) {
            $this->setHttpClient(new Zend_Http_Client);
        }
        return $this->_httpClient;
    }
    
    /**
     * @param string $url
     *
     * @return Core_Embed_Response
     */
    public function get($url)
    {        
        return $this->_parse($url);
    }
    
    /**
     * @param type $charset
     * 
     * @return array
     */
    protected function _detectType($type, $charset = 'utf-8')
    {
        if (preg_match('/(?P<type>[^;]+);\s*charset=(?P<charset>.+)/', $type, $matches)) {
            extract($matches);
        }
        
        return array(
            'type'    => strtolower(trim($type)),
            'charset' => strtolower(trim($charset))
        );
    }
    
    /**
     * @param string             $url      URL to parse
     * @param Zend_Http_Response $response URL content already fetched
     * 
     * @return Core_Embed_Response
     */
    abstract protected function _parse($url);
}
