<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Embed
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Embed
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Embed
{
    const FORMAT_JSON = 'json';
    const FORMAT_XML  = 'xml';

    /**
     * @var Zend_Http_Client
     */
    protected $_httpClient;
    
    /**
     * @var Core_Loader_PluginLoader
     */
    protected $_pluginLoader;

    /**
     * @var string
     */
    protected $_format;

    /**
     * @var integer
     */
    protected $_maxWidth;

    /**
     * @var integer
     */
    protected $_maxHeight;
    
    /**
     * @param Zend_Http_Client $httpClient
     *
     * @return \Core_Embed_Proxy
     */
    public function setHttpClient(Zend_Http_Client $httpClient)
    {
        $this->_httpClient = $httpClient;
        return $this;
    }

    /**
     * @return Zend_Http_Client
     */
    public function getHttpClient()
    {
        if (null === $this->_httpClient) {
            $httpClient = new Zend_Http_Client;
            $httpClient->setConfig(array(
                'timeout' => 60,
            ));
            $this->setHttpClient($httpClient);
        }
        return $this->_httpClient;
    }
    
    /**
     * @param Core_Loader_PluginLoader $pluginLoader
     *
     * @return Core_Embed
     */
    public function setPluginLoader(Core_Loader_PluginLoader $pluginLoader)
    {
        $this->_pluginLoader = $pluginLoader;
        return $this;
    }

    /**
     * If not set, fetch from Core_Application
     *
     * @return Core_Loader_PluginLoader
     */
    public function getPluginLoader()
    {
        if (null === $this->_pluginLoader) {
            $this->setPluginLoader(Core_Application::get('PluginLoader'));
        }
        return $this->_pluginLoader;
    }

    /**
     * @param string $format
     *
     * @return \Core_Embed
     */
    public function setFormat($format)
    {
        $this->_format = $format;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormat()
    {
        return $this->_format;
    }

    /**
     * @param integer $maxWidth
     *
     * @return \Core_Embed
     */
    public function setMaxWidth($maxWidth)
    {
        $this->_maxWidth = $maxWidth;
        return $this;
    }

    /**
     * @return integer
     */
    public function getMaxWidth()
    {
        return $this->_maxWidth;
    }

    /**
     * @param integer $maxHeight
     *
     * @return \Core_Embed
     */
    public function setMaxHeight($maxHeight)
    {
        $this->_maxHeight = $maxHeight;
        return $this;
    }

    /**
     * @return integer
     */
    public function getMaxHeight()
    {
        return $this->_maxHeight;
    }

    /**
     * @param string $url
     *
     * @return \Core_Embed_Response
     */
    public function get($url)
    {
        $parser = $this->_findSuitableParser($url);
        if ($parser instanceof Core_Embed_Parser_Interface) {
            $response = $parser->get($url);
            $response->setFormat($this->getFormat());
            return $response;
        }

        return new Core_Embed_Response(null);
    }
    
    /**
     * @param string $url
     * 
     * @return null|Core_Embed_Parser_Interface
     */
    protected function _findSuitableParser($url)
    {
        // try to figure out which parser to use here
        $plugin     = null;
        $httpClient = $this->getHttpClient();
        $httpClient->setUri($url);
        $response   = $httpClient->request(Zend_Http_Client::HEAD);
        if ($response->isError()) {
            // most common is 404 "Not found"
        }
        $type       = $response->getHeader('Content-Type');
        if (false !== ($idx = strpos($type, ';'))) {
            $type = substr($type, 0, $idx);
        }
        switch(trim($type)) {
            case 'image/gif':
            case 'image/png':
            case 'image/jpeg':
                $plugin = 'Image';
                break;
            case 'text/xml':
            case 'text/html':
                $plugin = 'Markup';
                break;
            default:
                $plugin = 'Fallback';
                break;
        }
        $parser = $this->getPluginLoader()->initializeEmbedParserPlugin($plugin);
        $parser->setHttpClient($this->getHttpClient());
        return $parser;
    }
}
