<?php

abstract class Core_Doctrine_Model_User extends Base_User implements
    Core_User_Model_Interface,
    Core_Security_Resource_Interface
{
    const SALT          = 'ovz7ot34qh3qcbghk9p4wx5vmg5834hqf8t9gvatz37';
    const SALT_LENGTH   = 9;

    public function getFirstName()
    {
        return $this->_get('first_name');
    }

    public function getLastName()
    {
        return $this->_get('last_name');
    }

    public function getTitle()
    {
        return $this->getFirstName() .' '. $this->getLastName();
    }

    /**
     * @param string $password
     *
     * @return \User
     */
    public function setPassword($password)
    {
        $this->_set('password', $this->hashPassword($password));

        return $this;
    }

    /**
     * @param string $string
     * @param string $salt
     *
     * @return string
     */
    public function hashPassword($string, $salt = null)
    {
        $salt = substr($salt, 0, self::SALT_LENGTH);
        $hash = $salt . sha1($salt . $string);
        return $hash;
    }

    public function getId()
    {
        return $this->_get('id');
    }

    public function getRoles()
    {
        return array($this->role);
    }

    public function getSecurityResource()
    {
        return 'model:user';
    }
}