<?php
class Core_Doctrine_Manager extends Doctrine_Manager
{
    protected $_adapterOptions = array();

    private function __construct()
    {
        $null = new Doctrine_Null;
        Doctrine_Locator_Injectable::initNullObject($null);
        Doctrine_Record_Iterator::initNullObject($null);
    }

    public static function getInstance()
    {
        if ( ! isset(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function setAdapterOption($name, $value)
    {
        $this->_adapterOptions[$name] = $value;
        return $this;
    }

    public function openConnection($adapter, $name = null, $setCurrent = true)
    {
        $connection     = parent::openConnection($adapter, $name, $setCurrent);
        $adapterOptions = $connection->getOption('other') + $this->_adapterOptions;
        $connection->setOption('other', $adapterOptions);
        return $connection;
    }
}