<?php
class Core_Doctrine_Cache_Managed extends Doctrine_Cache_Driver
{
    /** @var  string */
    protected $cacheName = 'default';

    /**
     * @var Zend_Cache_Backend_ExtendedInterface
     */
    protected $cache;

    public function __construct($options = array())
    {
        parent::__construct($options);
    }

    protected function _doFetch($id, $testCacheValidity = true)
    {
        return $this->getCache()->load($id);
    }

    protected function _doContains($id)
    {
        return (bool) $this->getCache()->load($id);
    }

    protected function _doSave($id, $data, $lifeTime = false)
    {
        return $this->getCache()->save($data, $id, array(), $lifeTime);
    }

    protected function _doDelete($id)
    {
        return $this->getCache()->remove($id);
    }

    protected function _getCacheKeys()
    {
        return array();
    }

    /**
     * @param string $name
     *
     * @return Core_Doctrine_Cache_Managed
     */
    public function setCacheName($name)
    {
        $this->cacheName = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getCacheName()
    {
        return $this->cacheName;
    }

    /**
     * @return Zend_Cache_Backend_ExtendedInterface
     */
    public function getCache()
    {
        if (null === $this->cache) {
            $this->cache = Core_Application::get('cacheManager')->get($this->getCacheName());
        }

        return $this->cache;
    }
    
}
