<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Dispatcher_Location
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Dispatcher_Location
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Dispatcher_Location implements Core_Dispatcher_Location_Interface
{
    /**
     * @var Core_Request
     */
    protected $_request;

    /**
     * @var string
     */
    protected $_module;

    /**
     * @var string
     */
    protected $_controller;

    /**
     * @var string
     */
    protected $_action;

    /**
     * Class constructor
     *
     * @param array $options
     */
    public function __construct($options = null)
    {
        if (is_array($options)) {
            $this->setOptions($options);
        }
    }

    /**
     * @param Core_Request $request
     *
     * @return Core_Dispatcher_Location
     */
    public function setRequest(Core_Request $request)
    {
        $this->_request = $request;
        return $this;
    }

    /**
     * @return Core_Request
     */
    public function getRequest()
    {
        if (null === $this->_request) {
            $this->setRequest(Core_Application::get('Request'));
        }
        return $this->_request;
    }

    /**
     * @param string $module
     *
     * @return \Core_Dispatcher_Location
     */
    public function setModule($module)
    {
        $this->_module = $module;
        return $this;
    }

    /**
     * @return string
     */
    public function getModule()
    {
        if (null === $this->_module) {
            $this->setModule($this->getRequest()->getParam('module'));
        }
        return $this->_module;
    }

    /**
     * @param string $controller
     *
     * @return \Core_Dispatcher_Location
     */
    public function setController($controller)
    {
        $this->_controller = $controller;
        return $this;
    }

    /**
     * @return string
     */
    public function getController()
    {
        if (null === $this->_controller) {
            $this->setController($this->getRequest()->getParam('controller'));
        }
        return $this->_controller;
    }

    /**
     * @param string $action
     *
     * @return \Core_Dispatcher_Location
     */
    public function setAction($action)
    {
        $this->_action = $action;
        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        if (null === $this->_action) {
            $this->setAction($this->getRequest()->getParam('action'));
        }
        return $this->_action;
    }

    /**
     * Set options.
     *
     * Will skip "request", "options". Will ignore unknown options
     *
     * @param array $options
     *
     * @return Core_Dispatcher_Location
     */
    public function setOptions(array $options)
    {
        $forbidden = array('Request', 'Options');

        foreach ($options as $key => $value) {
            $normalized = ucfirst($key);
            if (in_array($normalized, $forbidden)) {
                continue;
            }

            $method = 'set' . $normalized;
            if (method_exists($this, $method)) {
                $this->$method($value);
            }
        }
        return $this;
    }
}
