<?php
/**
 * Core Detector Client
 *
 * - used as a proxy to send requests with additional data
 * - i.e. a page submits data using AJAX to itself, client processes it, adds additional fields to store available only via PHP
 * - sends it to Core_Detector_Server API
 *
 * @author: Zwer 01/2013
 *
 * @copyright (c) 2013, Web.Burza
 *
 */

class Core_Detector_Client {

    /**
     * Core_Detector_Server API url
     */
    const API_URL                       = 'http://users.web/ante/detector/';

    /**
     * Custom data that will be stored via API
     *
     * @var array
     */
    protected $_customData              = null;

    /**
     * Detection ID, returned by Core_Detector_Server after request
     * @var type int
     */
    protected $_detectionId             = null;

    /**
     * Detection properties that we wish to return after API request
     * @var type array
     */
    protected $_detectionProperties     = null;


    public function __construct()
    {
        // do we do something?
    }

    /**
     * Gets data posted to API via AJAX requests
     *
     * @return Detector_Server
     */
    public function getData()
    {
        $this->_data    = $_POST;
        return $this;
    }


    /**
     * Validate request - might need this
     *
     * @return Core_Detector_Client
     * @throws ErrorException
     */
    public function _validate()
    {
        return $this;
    }


    /**
     * Set properties we need returned after API request
     * - by default we will get detection ID after storing
     * - i.e. 'screen.width', 'user_id', etc.
     *
     * @param   array   $properties
     * @return \Core_Detector_Client
     */
    public function requestDetectionProperties($properties)
    {
        if (is_array($properties)) {
            $this->_detectionProperties = $properties;
        }
        return $this;
    }

    /**
     * Set custom data to be stored to detector
     * - i.e. user_data, order_data, etc.
     * @param   array   $data
     * @return  \Core_Detector_Client
     */
    public function setCustomData($data)
    {
        $this->_customData  = $data;
        return $this;
    }

    /**
     * Store detector info to database
     *
     * @param   \Core_Detector_Request
     * @return  array
     */
    public function submit(Core_Detector_Request $detectorRequest)
    {
        // init curl object
        $ch     = curl_init();

        // set cURL parameters
        $params = array(
            CURLOPT_URL             => self::API_URL,         // POST to this url
            CURLOPT_POST            => true,
            CURLOPT_POSTFIELDS      => http_build_query($detectorRequest->getData(), null, '&'),
            CURLOPT_FOLLOWLOCATION  => true,
            CURLOPT_TIMEOUT         => 5,
            CURLOPT_VERBOSE         => false,
            CURLOPT_FRESH_CONNECT   => true,
            CURLOPT_RETURNTRANSFER  => true,
        );

        // init params
        curl_setopt_array($ch, $params);

        // execute request and return JSON response array
        $jsonResponse   =  curl_exec($ch);

        $response   = new Core_Detector_Response($jsonResponse);
        
        return $response;

    }

}
