<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Config
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Config
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Config_Ini extends Zend_Config_Ini
{
    /**
     * @param string $filename
     *
     * @return array
     * @throws Zend_Config_Exception
     */
    protected function _loadIniFile($filename)
    {
        $loaded = $this->_parseIniFile($filename);
        $iniArray = array();
        foreach ($loaded as $key => $data)
        {
            if (is_array($data)) {
                $pieces  = explode($this->_sectionSeparator, $key);
            } else {
                // we have a section separator in value name but no sections in INI file
                $pieces  = array($key);
            }
            $thisSection = trim($pieces[0]);
            switch (count($pieces)) {
                case 1:
                    $iniArray[$thisSection] = $data;
                    break;

                case 2:
                    $extendedSection = trim($pieces[1]);
                    $iniArray[$thisSection] = array_merge(array(';extends'=>$extendedSection), $data);
                    break;

                default:
                    /**
                     * @see Zend_Config_Exception
                     */
                    require_once 'Zend/Config/Exception.php';
                    throw new Zend_Config_Exception("Section '$thisSection' may not extend multiple sections in $filename");
            }
        }

        return $this->_normalizeType($iniArray);
    }

    /**
     * Normalize values loaded from INI file via pre-PHP 5.3 parse_ini_file()
     *
     * @param array $array Array loaded with parse_ini_file()
     *
     * @return array Array with normalized values
     * @throws Zend_Config_Exception
     */
    protected function _normalizeType(Array $array)
    {
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $value = $this->_normalizeType($value);
            } else {
                $value = trim($value, "'");
                if ('null' === strtolower($value)) {
                    $value = null;
                } else if (is_numeric($value)) {
                    $value = (false === strpos($value, '.') ? intval($value) : floatval($value));
                } else if (in_array(($bool = strtolower($value)), array('true', 'false'))) {
                    $value = ($bool === 'true');
                } else if (false !== strpos($value, '::')) {
                    // this might be a class constant
                    list($className, ) = explode('::', $value);
                    if (class_exists($className)) {
                        // references a real class
                        if (!defined($value)) {
                            throw new Zend_Config_Exception(sprintf('Constant %s not defined', $value));
                        }
                        $value = constant($value);
                    }
                }
            }
            $array[$key] = $value;
        }
        return $array;
    }
}
