<?php
/*
 * This is a quick place to place compatibilty functionality for PHP functionality
 * which is missing (for example, 5.3's backported functions, methods and constants),
 * or buggy. Everything here MUST check:
 *   - for existance of native implementation with function_exists() or defined() if backporting
 *   - for PHP version with version_compare() if buggy
 */
if (!function_exists('date_parse_from_format')) {
    // fallback for PHP < 5.3
    function date_parse_from_format($format, $date)
    {
        $known_formats = array(
            'j' => array('type' => 'day',    'length' => '1,2'),
            'd' => array('type' => 'day',    'length' => '2'),
            'n' => array('type' => 'month',  'length' => '1,2'),
            'm' => array('type' => 'month',  'length' => '2'),
            'y' => array('type' => 'year',   'length' => '2'),
            'Y' => array('type' => 'year',   'length' => '4'),
            'G' => array('type' => 'hour',   'length' => '1,2'),
            'H' => array('type' => 'hour',   'length' => '2'),
            'i' => array('type' => 'minute', 'length' => '2'),
            's' => array('type' => 'second', 'length' => '2'),
            'U' => array('type' => 'timestamp', 'regex' => '\d+'),
        );

        /**
        * Creating reqexp from date format
        */
        $str_len    = strlen($format);
        $reqexp_str = '#';
        for ($i = 0; $i < $str_len; $i++) {
            $char = $format[$i];
            if (array_key_exists($char, $known_formats)) {
                $reqexp_str .= '(?P<' . $known_formats[$char]['type'] . '>'. (isset($known_formats[$char]['regex']) ? $known_formats[$char]['regex'] : '\d{'. $known_formats[$char]['length'] .'}') .')';
            } else {
                $reqexp_str .= $char;
            }
        }
        $reqexp_str .= '#';

        // preset empty values
        $ret = array(
            'year'           => false,
            'month'          => false,
            'day'            => false,
            'hour'           => false,
            'minute'         => false,
            'second'         => false,
            'fraction'       => false,
            'warning_count'  => 0,
            'warnings'       => array(),

            'error_count'    => 0,
            'errors'         => array(),

            'is_localtime'   => false,
            'zone_type'      => 0,
            'zone'           => 0,
            'is_dst'         => 0,
        );

        if (preg_match($reqexp_str, $date, $matches)) {
            if (isset($matches['timestamp'])) {
                // create the date/time bits from timestamp
                $date = getdate($matches['timestamp']);
                $matches = array(
                    'year'   => $date['year'],
                    'month'  => $date['mon'],
                    'day'    => $date['mday'],
                    'hour'   => $date['hours'],
                    'minute' => $date['minutes'],
                    'second' => $date['seconds'],
                );
            }

            $ret = array_merge($ret, $matches);

            // simple data validations, mimmick real function

            // date
            if ($ret['month'] && $ret['day'] && $ret['year'] && !checkdate($ret['month'], $ret['day'], $ret['year'])) {
                $ret['warning_count']++;
                $ret['warnings'][] = 'The parsed date was invalid';
            }

            // time
            if (
                ($ret['hour']   && ($ret['hour']   < 0 || $ret['hour'] > 23))
             || ($ret['minute'] && ($ret['minute'] < 0 || $ret['minute'] > 59))
             || ($ret['second'] && ($ret['second'] < 0 || $ret['second'] > 59))
            ) {
                $ret['warning_count']++;
                $ret['warnings'][] = 'The parsed time was invalid';
            }
        } else {
            // error parsing this
            $ret['error_count']++;
            $ret['errors'][] = 'Error parsing data';
        }
        return $ret;
    }
}

if (!function_exists('date_parsed_to_timestamp')) {
    function date_parsed_to_timestamp($parsed)
    {
        $time = null;
        if ($parsed['error_count'] == 0 && $parsed['warning_count'] == 0) {
            $time = mktime(
                    (isset($parsed['hour'])   ? $parsed['hour']   : 0),
                    (isset($parsed['minute']) ? $parsed['minute'] : 0),
                    (isset($parsed['second']) ? $parsed['second'] : 0),
                    (isset($parsed['month'])  ? $parsed['month']  : 0),
                    (isset($parsed['day'])    ? $parsed['day']    : 0),
                    (isset($parsed['year'])   ? $parsed['year']   : 0));
        }
        return $time;
    }
}

if (!function_exists('stream_resolve_include_path')) {
    function stream_resolve_include_path($filename)
    {
        $includePaths = explode(PATH_SEPARATOR, get_include_path());
        foreach ($includePaths as $includePath) {
            $filePath = $includePath . DIRECTORY_SEPARATOR . $filename;
            if (file_exists($filePath)) {
                return $filePath;
            }
        }
        return false;
    }
}

if (!function_exists('mime_content_type')) {
    function mime_content_type($file) {
        return exec("file -bi " . escapeshellarg($file));
    }
}

if (!function_exists('array_column')) {
    function array_column(array $array, $column_key, $index_key = null)
    {
        $new = array();
        foreach ($array as $item) {
            if (null !== $column_key) {
                $value = $item[$column_key];
            }
            if (null !== $index_key) {
                $key       = $item[$index_key];
                $new[$key] = $value;
            } else {
                $new[] = $value;
            }
        }
        return $new;
    }
}

if (!defined('E_DEPRECATED')) {
    define('E_DEPRECATED',       8192);
    define('E_USER_DEPRECATED', 16384);
}

if (!defined('JSON_PRETTY_PRINT')) {
    define('JSON_PRETTY_PRINT', 128);
}