<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Calendar
 * @subpackage Core_Calendar_Interval
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Calendar
 * @subpackage Core_Calendar_Interval
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
class Core_Calendar_Interval_Month
{
    /**
     * @var integer
     */
    protected $_year;

    /**
     * @var integer
     */
    protected $_month;

    /**
     * @var integer
     */
    protected $_day;

    public function setYear($year)
    {
        $this->_year = $year;
        return $this;
    }

    public function getYear()
    {
        if (null === $this->_year) {
            $this->_year = date('Y');
        }
        return $this->_year;
    }

    public function setMonth($month)
    {
        $this->_month = $month;
        return $this;
    }

    public function getMonth()
    {
        if (null === $this->_month) {
            $this->_month = date('m');
        }
        return $this->_month;
    }

    public function setDay($day)
    {
        $this->_day = $day;
        return $this;
    }

    public function getDay()
    {
        return $this->_day;
    }

    public function setDate(array $date)
    {
        $specs = array('year', 'month', 'day');
        foreach($date as $key => $value) {
            if (in_array($key, $specs)) {
                call_user_func(array($this, 'set'. ucfirst($key)), $value);
            }
        }
    }
}