<?php
class Core_Cache_Manager extends Zend_Cache_Manager
{

    /**
     * @param array|Zend_Config $templates
     */
    public function __construct($templates = null)
    {
        if (null !== $templates) {
            $this->setCacheTemplates($templates);
        }
    }

    /**
     * Set a named configuration template from which a cache object can later
     * be lazy loaded
     *
     * @param  array $templates
     *
     * @throws Zend_Cache_Exception
     * @return Core_Cache_Manager
     */
    public function setCacheTemplates($templates)
    {
        if ($templates instanceof Zend_Config) {
            $templates = $templates->toArray();
        } elseif (!is_array($templates)) {
            require_once 'Zend/Cache/Exception.php';
            throw new Zend_Cache_Exception('Options passed must be in'
                . ' an associative array or instance of Zend_Config');
        }
        foreach ($templates as $name => $options) {
            $this->setCacheTemplate($name, $options);
        }
        return $this;
    }

    // this is a proxy to DI container!
    public function __call($name, $params)
    {
        // accessing manager items!
        // getView() => getContainer()->get('view')
        // ...
        $matches = array();
        if (preg_match('/^get(?P<name>.*)Cache$/', $name, $matches)) {
            return $this->getCache(strtolower($matches['name']));
        }

            // no such method!
        throw new Exception(sprintf('Call to undefined method %s::%s()', get_class($this), $name));
    }

    /**
     * @param string $name
     *
     * @return Zend_Cache_Core
     */
    public function get($name)
    {
        return $this->getCache($name);
    }
}