<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Cache
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Cache
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Cache extends Zend_Cache
{
    /**
     * Store data (most often, an array) as a precompiled PHP file
     *
     * @param string $cacheFile Path to store the cache file
     * @param mixed  $data      Data to cache
     *
     * @param string $sourcePath
     *
     * @throws InvalidArgumentException
     * @return void
     */
    static public function cache($cacheFile, $data, $sourcePath = null)
    {
        if (!((file_exists($cacheFile) && is_writable($cacheFile)) || is_writable(dirname($cacheFile)))) {
            throw new InvalidArgumentException(sprintf('%s: Cannot write cache to file %s', __CLASS__, $cacheFile));
        }

        return file_put_contents($cacheFile, sprintf("<?php\n// generated: %s\n%sreturn %s;",
            date('c'),
            (null !== $sourcePath ? "// source:    ". $sourcePath ."\n" : null),
            var_export($data, true)
        ));

    }
}