<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Application
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Application
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
class Core_Application_Plugin_EventHandler_Profiler extends Core_Application_Plugin_EventHandler_Abstract
{
    /**
     * @var array
     */
    protected $_subscriptions = array(
        array(
            'event'    => Core_Application::EVENT_SHUTDOWN,
            'method'   => 'eventHandler',
            'priority' => 99999,
        ),
    );

    /**
     * @var int
     */
    protected $_rate      = 100;

    /**
     * @var int
     */
    protected $_threshold = 150000;

    /**
     * @var string
     */
    protected $_component;

    /**
     * @var Core_Application_Plugin_EventHandler_Profiler_Interface
     */
    protected $_model;

    /**
     * @return void
     */
    public function init()
    {
        if (1 == mt_rand(1, $this->getRate())) {
            xhprof_enable(XHPROF_FLAGS_CPU | XHPROF_FLAGS_MEMORY);
        }

        parent::init();
    }

    /**
     * @param Core_Event_Interface $event Event, ignored
     * @param mixed                $data  Event data, ignored
     */
    public function eventHandler(Core_Event_Interface $event, $data = null)
    {
        $data = xhprof_disable();
        if ($data) {
            $profile = new Core_Xhprof_Profile($data);
            $this->getModel()->persistProfile($profile, $this->getThreshold());
        }
    }

    /**
     * @param int $rate
     *
     * @return \Core_Application_Plugin_EventHandler_Profiler
     */
    public function setRate($rate)
    {
        $this->_rate = $rate;
        return $this;
    }

    /**
     * @return int
     */
    public function getRate()
    {
        return $this->_rate;
    }

    /**
     * @param int $threshold Microseconds
     *
     * @return \Core_Application_Plugin_EventHandler_Profiler
     */
    public function setThreshold($threshold)
    {
        $this->_threshold = $threshold;
        return $this;
    }

    /**
     * @return int Microseconds
     */
    public function getThreshold()
    {
        return $this->_threshold;
    }

    /**
     * @param string $component
     *
     * @return Core_Application_Plugin_EventHandler_Profiler
     */
    public function setComponent($component)
    {
        $this->_component = $component;
        return $this;
    }

    /**
     * @throws InvalidArgumentException
     * @return string
     */
    public function getComponent()
    {
        if (null === $this->_component) {
            throw new InvalidArgumentException('Failed fetching component name, no component name set');
        }
        return $this->_component;
    }

    /**
     * @param Core_Application_Plugin_EventHandler_Profiler_Interface $model
     *
     * @return \Core_Router_Route_Plugin_Model
     */
    public function setModel(Core_Application_Plugin_EventHandler_Profiler_Interface $model)
    {
        $this->_model = $model;
        return $this;
    }

    /**
     * @throws InvalidArgumentException
     * @return Core_Application_Plugin_EventHandler_Profiler_Interface
     */
    public function getModel()
    {
        if (null === $this->_model) {
            $model = Core_Application::get($this->getComponent());
            if (!$model instanceof Core_Application_Plugin_EventHandler_Profiler_Interface) {
                throw new InvalidArgumentException(sprintf(
                    'Failed fetching named component %s for Profiler plugin, '
                  . 'component must be an instance of Core_Application_Plugin_EventHandler_Profiler_Interface',
                    $this->getComponent()
                ));
            }
            $this->setModel($model);
        }
        return $this->_model;
    }
}