<?php
/**
 * core.framework
 *
 * @category  Core
 * @package   Core_Application
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */

/**
 * @category  Core
 * @package   Core_Application
 * @copyright Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license   proprietary
 */
abstract class Core_Application_Plugin_EventHandler_Abstract extends Core_Application_Plugin_Abstract
{
    /**
     * @var Core_Dispatcher
     */
    protected $_dispatcher;

    /**
     * @var Core_Event_Dispatcher_Interface
     */
    protected $_eventDispatcher;

    /**
     * @var Core_Module_ResourceFinder
     */
    protected $_resourceFinder;

    /**
     * @var array
     */
    protected $_subscriptions;

    /**
     * @return void
     * @throws RuntimeException
     */
    public function init()
    {
        if ($this->_subscriptions) {
            $eventDispatcher = $this->getEventDispatcher();
            foreach ($this->_subscriptions as $subscription) {
                $eventDispatcher->subscribe(
                    $subscription['event'],
                    array($this, $subscription['method']),
                    (isset($subscription['priority']) ? $subscription['priority'] : 0),
                    (isset($subscription['filter'])   ? $subscription['filter']   : 0)
                );
            }
        }
    }

    /**
     * @param Core_Dispatcher $dispatcher
     *
     * @return \Core_Application_Plugin_EventHandler_Abstract
     */
    public function setDispatcher(Core_Dispatcher $dispatcher)
    {
        $this->_dispatcher = $dispatcher;
        return $this;
    }

    /**
     * @return Core_Dispatcher
     */
    public function getDispatcher()
    {
        if (null === $this->_dispatcher) {
            $this->setDispatcher(Core_Application::get('Dispatcher'));
        }
        return $this->_dispatcher;
    }

    /**
     * @param Core_Event_Dispatcher_Interface $eventDispatcher
     *
     * @return \Core_Application_Plugin_EventHandler_Abstract
     */
    public function setEventDispatcher(Core_Event_Dispatcher_Interface $eventDispatcher)
    {
        $this->_eventDispatcher = $eventDispatcher;
        return $this;
    }

    /**
     * @return Core_Event_Dispatcher_Interface
     */
    public function getEventDispatcher()
    {
        if (null === $this->_eventDispatcher) {
            $this->setEventDispatcher($this->getDispatcher()->getEventDispatcher());
        }
        return $this->_eventDispatcher;
    }

    /**
     * @param Core_Module_ResourceFinder $resourceFinder
     *
     * @return Core_Controller_Abstract
     */
    public function setResourceFinder(Core_Module_ResourceFinder $resourceFinder)
    {
        $this->_resourceFinder = $resourceFinder;
        return $this;
    }

    /**
     * @return Core_Module_ResourceFinder
     */
    public function getResourceFinder()
    {
        if (null === $this->_resourceFinder) {
            $this->setResourceFinder(Core_Application::get('ResourceFinder'));
        }
        return $this->_resourceFinder;
    }
}
