<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Application
 * @subpackage Plugin
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Application
 * @subpackage Plugin
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */
abstract class Core_Application_Plugin_Abstract implements Core_Application_Plugin_Interface
{
    /**
     * @var string
     */
    protected $_name;

    /**
     * @param string $name    Plugin name
     * @param array  $options Plugin options
     */
    public function __construct($name, array $options = null)
    {
        $this->setName($name);

        if (is_array($options)) {
            $this->setOptions($options);
        }
    }

    /**
     * @param string $name
     *
     * @return \Core_Application_Plugin_Abstract
     */
    public function setName($name)
    {
        $this->_name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->_name;
    }

    /**
     * @param array $options
     *
     * @return \Core_Application_Plugin_Abstract
     * @throws InvalidArgumentException
     */
    public function setOptions(array $options)
    {
        foreach ($options as $key => $value) {
            $normalized = ucfirst($key);

            $callable = array($this, 'set' . $normalized);
            if (is_callable($callable)) {
                call_user_func($callable, $value);
            } else {
                throw new InvalidArgumentException(sprintf('Invalid option "%s" passed', $key));
            }
        }
        return $this;
    }
}
