<?php

/**
 * Class Core_Application_Component
 *
 * these components are dynamically built so make sure to run script first
 * getters can be used only after successful built framework/bin/components-builder
 *
 * @method static Core_Application_Component getInstance()
 */
class Core_Application_Component extends Core_Singleton {

    /**
     * @return Core_Application_Component_Container
     */
    public function getContainer()
    {
        return Core_Application_Component_Container::getInstance();
    }

    /**
     * @return Core_Application_Component_Models
     */
    public function getModels()
    {
        return Core_Application_Component_Models::getInstance();
    }

    public function getConfig()
    {
        return $this->getContainer()->modelsConfig;
    }

} 