<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_TextareaTemplateTest extends CoreTest_Template_TestCase
{
    /**
     * @var string
     */
    protected $_path = 'Form/Element/Textarea.tpl';

    /**
     * @return array
     */
    public function getMatches()
    {
        return array(
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array())),
                ),
                // expected XML
                '<textarea></textarea>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23))),
                ),
                // expected XML
                '<textarea foo="23"></textarea>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23), 'getValue' => 'bla')),
                ),
                // expected XML
                '<textarea foo="23">bla</textarea>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23), 'getValue' => '<markup/>')),
                ),
                // expected XML
                '<textarea foo="23">&lt;markup/&gt;</textarea>'
            ),
        );
    }
}
