<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_InputTemplateTest extends CoreTest_Template_TestCase
{
    /**
     * @var string
     */
    protected $_path = 'Form/Element/Input.tpl';

    /**
     * @return array
     */
    public function getMatches()
    {
        return array(
            array(
                // twig vars
                array(
                    'this'    => $this->_mock(array('getAttribs' => array())),
                    'context' => 'default',
                ),
                // expected XML
                '<input/>'
            ),
            array(
                // twig vars
                array(
                    'this'    => $this->_mock(array('getAttribs' => array('foo' => 23))),
                    'context' => 'default',
                ),
                // expected XML
                '<input foo="23"/>'
            ),
        );
    }
}
