<?php
/**
 * core.framework
 *
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 */

/**
 * @category   Core
 * @package    Core_Form
 * @subpackage TemplateTests
 * @copyright  Copyright (c) 2011. Burza d.o.o. (http://web.burza.hr/en/)
 * @license    proprietary
 * @group      Core_Form
 */
class Core_Form_Element_ButtonTemplateTest extends CoreTest_Template_TestCase
{
    /**
     * @var string
     */
    protected $_path = 'Form/Element/Button.tpl';

    /**
     * @return array
     */
    public function getMatches()
    {
        return array(
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array())),
                ),
                // expected XML
                '<button></button>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23))),
                ),
                // expected XML
                '<button foo="23"></button>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23), 'getLabel' => 'foo')),
                ),
                // expected XML
                '<button foo="23">foo</button>'
            ),
            array(
                // twig vars
                array(
                    'this' => $this->_mock(array('getAttribs' => array('foo' => 23), 'getLabel' => '<markup/>')),
                ),
                // expected XML
                '<button foo="23"><markup/></button>'
            ),
        );
    }
}
