<?php
// we're checkin for TESTS_ROOT because we can run some of the tests
// in a separate process via @runInSeparateProcess annotation
if (!defined('TESTS_ROOT')) {
    define('TESTS_ROOT', dirname(__FILE__));
}

error_reporting(E_ALL | E_STRICT);
ini_set('display_errors', true);
ini_set('date.timezone', 'Europe/Zagreb');

set_include_path(implode(PATH_SEPARATOR, array(
    TESTS_ROOT .'/../../../lib',
    TESTS_ROOT .'/../../../tests/resources/lib',
    TESTS_ROOT .'/lib',
    get_include_path()
)));

// setup autoloader
require_once 'Core/Loader.php';
$loader = new Core_Loader;
$loader->registerBasicAutoloader();

// will use global to inject this to tests
$loader = new Twig_Loader_Filesystem(array(
    TESTS_ROOT .'/../lib/Core'
));
$twig   = new Twig_Environment($loader, array(
    'base_template_class' => 'Core_Twig_Template',
    'trim_block'          => true,
    'auto_reload'         => true,
    'autoescape'          => 'html',
    'debug'               => true,
));
$twig->addExtension(new Core_Twig_Extensions_Extension_Form);
$twig->addExtension(new Core_Twig_Extensions_Extension_Asset);
$twig->addExtension(new Core_Twig_Extensions_Extension_Router);
$twig->addExtension(new Core_Twig_Extensions_Extension_String);