{% macro process(object, context) %}
    {% for group in object.getGroups() %}
        {{ _self.call(group.macro, group, context) }}
    {% endfor %}

    {% for element in object.getElements() %}
        {{ _self.call(element.macro, element, context) }}
    {% endfor %}
{% endmacro %}


{% macro form(form, context) %}
<form{{ form.getAttribs(context)|attribs }}>
    {{ _self.process(form, context) }}
</form>
{% endmacro %}


{% macro group(group, context) %}
<div class="cf-form-group"{{ group.getAttribs(context)|attribs }}>
    {{ _self.helper_group_label(group.label) }}
    {{ _self.process(group, context) }}
</div>
{% endmacro %}


{% macro display_group(group, context) %}
<div{{ group.getAttribs(context)|attribs }}>
    {{ _self.helper_group_label(group.label) }}
    {{ _self.process(group, context) }}
</div>
{% endmacro %}


{% macro collection(collection, context, params) %}
<div{{ _self.helper_attribs(params, 'container', 0, 'cf-form-collection-container') }}>
    {{ _self.helper_group_label(collection.label) }}
    <div class="cf-form-collection"{{ collection.getAttribs(context)|attribs }}>
        <script type="html/prototype">{{ collection.prototypeInstance.render(context)|raw }}</script>
        <div class="cf-form-collection-items">
        {{ _self.process(collection, context) }}
        </div>
    </div>
    {{ _self.helper_element_errors(collection.error) }}
</div>
{% endmacro %}


{% macro element(element, context, params) %}
<div{{ _self.helper_attribs(params, 'container', 0, 'cf-form-field') }}>

    <p{{ _self.helper_attribs(params, 'label', 1, 'cf-form-field-label') }}><label for="{{ element.fullyQualifiedId }}">{{ _self.helper_element_required(element.required) }}{{ element.label|raw }}</label></p>
    <p{{ _self.helper_attribs(params, 'element', 2, 'cf-form-field-element') }}>

        {% if element.error %}<span class="has-error">{% endif %}
            {{ element.render(context)|raw }}
        {% if element.error %}</span>{% endif %}

        {{ _self.helper_element_errors(element.error) }}
    </p>
</div>
{% endmacro %}


{% macro element_label_behind(element, context, params) %}
<div{{ _self.helper_attribs(params, 'container', 0, 'cf-form-field') }}>
    <span{{ _self.helper_attribs(params, 'element', 2, 'cf-form-field-element') }}>
        {{ element.render(context)|raw }}
        {{ _self.helper_element_errors(element.error) }}
    </span>
    <span{{ _self.helper_attribs(params, 'label', 1, 'cf-form-field-label') }}><label for="{{ element.fullyQualifiedId }}">{{ _self.helper_element_required(element.required) }}{{ element.label|raw }}</label></span>
</div>
{% endmacro %}



{% macro element_checkbox(element, context, params) %}
<div{{ _self.helper_attribs(params, 'container', 0, 'cf-form-field') }}>

    <p{{ _self.helper_attribs(params, 'label', 1, 'cf-form-field-label') }}>&nbsp;</p>

    <p{{ _self.helper_attribs(params, 'element', 2, 'cf-form-field-element') }}>
        <label for="{{ element.fullyQualifiedId }}">
            {{ element.render(context)|raw }}
            <span>{{ _self.helper_element_required(element.required) }} {{ element.label|raw }}</span>
        </label>
        {{ _self.helper_element_errors(element.error) }}
    </p>

</div>
{% endmacro %}



{% macro element_basic(element, context, params) %}
<div{{ _self.helper_attribs(params, 'container', 0, 'cf-form-field') }}>
    {{ element.render(context)|raw }}
</div>
{% endmacro %}


{% macro element_bare(element, context) %}
{{ element.render(context)|raw }}
{% endmacro %}





{% macro helper_attribs(params, property, index, class) %}
{% if attribute(params, property) %}
    {% set attribs = '' %}
    {% for key, value in attribute(params, property) %}
        {% if key == 'class' %}
            {% set attribs = attribs ~ ' ' ~ key ~ '="' ~ class ~ ' ' ~ value ~ '"' %}
        {% else %}
            {% set attribs = attribs ~ ' ' ~ key ~ '="' ~ value ~ '"' %}
        {% endif %}
    {% endfor %}
{% elseif attribute(params, index) %}
    {% set attribs = ' class="' ~ class ~ ' ' ~ attribute(params, index) ~ '"' %}
{% else %}
    {% set attribs = ' class="' ~ class ~ '"' %}
{% endif %}
{{ attribs|raw }}{% endmacro %}


{% macro helper_element_required(is_required) %}
{% if is_required %}<abbr title="Required" class="cf-form-required">&bull;</abbr> {% endif %}
{% endmacro %}


{% macro helper_element_errors(errors) %}
{% if errors %}
<span class="Form-errors-list">
    {% if errors is iterable %}
        {% for error in errors %}
        <span>{{ _self.error(error) }}</span>
        {% endfor %}
    {% else %}
        <span>{{ errors }}</span>
    {% endif %}
</span>
{% endif %}
{% endmacro %}


{% macro helper_group_label(label) %}
{% if label %}<div class="cf-form-group-label">{{ label }}</div>{% endif %}
{% endmacro %}