<style>
    #doctrine-debug {
        top: 0;
        right: 0;
        position: absolute;
        z-index: 10000;
        padding: 1em;
        max-width: 75%;
    }
    #doctrine-debug h1 {
        cursor: pointer;
    }
    #doctrine-debug h2 {
        margin: 0;
        padding: 0.5em;
        cursor: pointer;
    }
    #doctrine-debug h1:hover, #doctrine-debug h2:hover {
        color: #ff0000;
    }
    #doctrine-debug table {
        border: 1px solid #000000;
        border-collapse: collapse;
        width: 100%;
    }
    #doctrine-debug table thead>tr {
        display: block;
    }
    #doctrine-debug table tbody {
        display: block;
        max-height: 50em;
        overflow-y: auto;
    }
    #doctrine-debug table:hover tr.doctrine-debug-row-closed td {
        color: #a9a9a9;
    }
    #doctrine-debug table:hover tr:hover td {
        color: #000000;
    }
    #doctrine-debug, #doctrine-debug th, #doctrine-debug td {
        padding: 0 0.3em;
        background: white;
        border: 1px solid #000000;
        vertical-align: top;
        font-family: monospace;
    }
    #doctrine-debug td:nth-child(1), #doctrine-debug td:nth-child(2) {
        text-align: right;
    }
    #doctrine-debug td:nth-child(5) {
        min-width: 10em;
    }
    #doctrine-debug td div {
        text-overflow: ellipsis;
        overflow: hidden;
    }
    #doctrine-debug tr.doctrine-debug-row-closed {
        cursor: pointer;
    }
    #doctrine-debug tr.doctrine-debug-row-closed td div {
        max-height: 3em;
    }
    #doctrine-debug td pre {
        margin: 0;
    }

    #doctrine-debug.doctrine-debug-open h2 {
        display: none;
    }

    #doctrine-debug.doctrine-debug-closed {
        padding: 0;
    }
    #doctrine-debug.doctrine-debug-closed h2 {
        display: block;
    }
    #doctrine-debug.doctrine-debug-closed h1, #doctrine-debug.doctrine-debug-closed table {
        display: none;
    }
</style>
<div id="doctrine-debug" class="doctrine-debug-closed">
    <h1 title="Collapse" onclick="$('#doctrine-debug').removeClass('doctrine-debug-open').addClass('doctrine-debug-closed')">
        Doctrine events: {{ count }}, duration: {{ '%.03f'|format(total) }}s
    </h1>
    <h2 title="Expand" onclick="$('#doctrine-debug').removeClass('doctrine-debug-closed').addClass('doctrine-debug-open')">{{ count }}@{{ '%.03f'|format(total) }}s</h2>
    <table>
        <thead>
            <tr>
                <th>Seq</th>
                <th>Duration</th>
                <th>Type</th>
                <th>Query</th>
            </tr>
        </thead>
        <tbody>
        {% for query in events %}
        <tr class="doctrine-debug-row-closed" onclick="$(this).removeClass('doctrine-debug-row-closed')">
            <td>{{ loop.index }}</td>
            <td>{{ '%.03f'|format(query.secs) }}s</td>
            <td>{{ query.name }}</td>
            <td>
                <div>
                {% if query.query %}{{ query.query }}{% else %}-{% endif %}
                </div>
            </td>
        </tr>
        {% endfor %}
        </tbody>
    </table>
</div>