<% macro ActionBar(params) %>
{#
<div class="Actions">

    <div class="Actions-buttonGroup">
        <button type="submit" class="Button Button--large Button--def" title="Save draft">
            <i class="Button-icon fa fa-floppy-o"></i>
            <span class="Button-text">Save draft</span>
        </button>
        <button type="submit" class="Button Button--large Button--neutral" title="Discard changes">
            <i class="Button-icon fa fa-ban"></i>
            <span class="Button-text">Discard changes</span>
        </button>
    </div>

    <a href="#" class="Actions-revisionInfo c-meta fs-s">Last revision: <span class="c-dark">2014.03.01.</span> @ <span class="c-dark">22:14</span> by <span class="c-dark">Nepoznati Netko</span></a>

    <div class="Actions-mainAction Actions-wrapButton">
        <button type="submit" class="Button Button--large Button--action" title="Publish article">
            <i class="Button-icon fa fa-rocket"></i>
            <span class="Button-text">Publish article</span>
        </button>
    </div>

</div><!-- /.Actions -->
#}
<% endmacro %>



<% macro Panels(params) %>

<div class="Panel u-cf" ng-class="{'is-active': panelActive}">

    <ul class="Panel-tabs">
        <% for item in params.types %>
        <li class="Panel-tabs-item" ng-class="{active: panelActive == '<%= item.nameSingular %>'}">
            <a class="Panel-tabs-link" ng-click="panelActive = panelActive == '<%= item.nameSingular %>' ? null : '<%= item.nameSingular %>'">
                <i class="fa fa-<%= item.icon %>"></i>
                <span class="u-isHiddenVisually"><%= params.namePlural %></span>
            </a>
        </li>
        <% endfor %>
        <% if params.info %>
        <li class="Panel-tabs-item" ng-class="{active: panelActive == 'entityInfo'}">
            <a class="Panel-tabs-link" ng-click="panelActive = panelActive == 'entityInfo' ? null : 'entityInfo'">
                <i class="fa fa-info"></i>
                <span class="u-isHiddenVisually">info</span>
            </a>
        </li>
        <% endif %>
    </ul>

    <div class="Panel-content" cf-drag-files="filesDragged">
        <% for item in params.types %>
        <div class="Panel-content-inner" ng-show="panelActive == '<%= item.nameSingular %>'">
            <h3 class="Panel-content-title"><%= item.sectionTitle %></h3>
            <cf-browser data-source="<%= url({"entity": item.namePlural}, "api") %>"
                        content-type="<%= item.nameSingular %>"
                        limit="<%= item.limit|default('10') %>"
                        origin="<% if item.hasOrigin %>'<%= params.origin %>-' + id<% elseif item.origin %>'<%= item.origin %>'<% else %>''<% endif %>"
                        params="{'origin': <% if item.origin %>'<%= item.origin %>'<% else %>''<% endif %>, 'select': <% if item.select %>'<%= item.select %>'<% else %>null<% endif %>}"
                        finder="true"
                        uploader="<%= item.hasUploader ? 'true' : 'false' %>"
                        linkable="true"
                        <%= item.order ? 'order=' ~ item.order : '' %>
            <% if item.advancedSearch %>
                        advanced-search="<%= item.advancedSearch %>"
            <% endif %>
                        file-over="filesDragged" />
        </div>
        <% endfor %>
        <% if params.info %>
        <div class="Panel-content-inner" ng-show="panelActive == 'entityInfo'">
            <h3 class="Panel-content-title">Entity info</h3>
            <div style="padding-top:20px;" ng-if="<%= params.info %> && <%= params.info %>.id && <%= params.info %>.created_at!='0000-00-00 00:00:00'" ng-init="entity = <%= params.info %>;">
                    created <em>{{ entity.created_at }}</em> <br/>by <a ng-if="entity.createe.id" href="/admin/users/edit/{{ entity.createe.id }}/">{{ entity.createe.first_name }} {{ entity.createe.last_name }}</a>
                    <span ng-if="!entity.createe.id" >Unknown</span>
            </div>
            <div style="padding-top:20px;" ng-if="<%= params.info %> && <%= params.info %>.id && <%= params.info %>.updated_at!='0000-00-00 00:00:00'" ng-init="entity = <%= params.info %>;">
                updated <em>{{ entity.updated_at }}</em> <br/>by <a ng-if="entity.updatee.id" href="/admin/users/edit/{{ entity.updatee.id }}/">{{ entity.updatee.first_name }} {{ entity.updatee.last_name }}</a>
                <span ng-if="!entity.updatee.id" >Unknown</span>
            </div>
        </div>
        <% endif %>
    </div>
{#
    <!--ul class="Panel-tabs">
        <% for item in params.types %>
        <li class="Panel-tabs-item" ng-class="{active: panelActive && dataService.type == '<%= item.nameSingular %>'}">
            <a class="Panel-tabs-link" ng-click="switchPanelActive('<%= item.nameSingular %>'); setDataService('<%= item.nameSingular %>');">
                <i class="fa fa-<%= item.icon %>"></i>
                <span class="u-isHiddenVisually"><%= params.namePlural %></span>
            </a>
        </li>
        <% endfor %>
    </ul-->

    <!--div class="Panel-content" cf-drag-files="filesDragged">
        <div class="Panel-content-inner">
            <% for item in params.types %>
                <h3 class="Panel-content-title" ng-if="dataService.type == '<%= item.nameSingular %>'"><%= item.sectionTitle %></h3>
            <% endfor %>
            <cf-finder data-source="dataService" ng-hide="dataProps.uploader && filesDragged"></cf-finder>
            <cf-list data-source="dataService" linkable="true" highlight="dataProps.highlight" ng-hide="dataProps.uploader && filesDragged"></cf-list>
            <cf-pager data-source="dataService" ng-hide="dataProps.uploader && filesDragged"></cf-pager>
            <div ng-show="dataProps.uploader && filesDragged">
                <cf-uploader data-source="dataService" set-events="filesDragged"></cf-uploader>
            </div>
        </div>
    </div-->
#}
</div>

<% endmacro %>