<!DOCTYPE html>
<html ng-app="coreWebApp">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title ng-bind="title + ' - <%= app.config.app.name %>'"></title>

    <% set css_assets = [
        '/framework/style/jquery-ui/jquery-ui.custom.css',
        '/framework/style/jquery/jcrop.css',
        '/framework/style/kendo/kendo.common.min.css',
        '/framework/style/animate-css/animate.css',
        '/framework/style/font-awesome.min.css',
        '/framework/style/global.css',
        '/framework/style/p.css',
    ] %>

    <% if additional_css_assets %>
        <% set css_assets = css_assets|merge(additional_css_assets) %>
    <% endif %>

    <!-- PROCESS CSS ASSETS -->
    <% for asset in assets(css_assets) %>
    <link rel="stylesheet" href="<%= asset.getUrlPath() %>">
    <% endfor %>
    <script src="https://maps.googleapis.com/maps/api/js?v=3.exp&sensor=false&libraries=places"></script>
    <script src="/js/vendor/ckeditor/ckeditor.js"></script>
    <% set js_assets = [
        '/framework/javascript/typekit/webfont.js',
        '/framework/javascript/underscore/underscore.js',
        '/framework/javascript/greensock/TweenMax.js',
        '/framework/javascript/jquery/jquery.js',
        '/framework/javascript/jquery/jcrop.js',
        '/framework/javascript/jquery-ui/jquery-ui.custom.js',
        '/framework/javascript/bootstrap/bootstrap.js',
        '/framework/javascript/kendo/kendo.web.min.js',
        '/framework/javascript/angularjs/angular.js',
        '/framework/javascript/angularjs/angular-route.js',
        '/framework/javascript/angularjs/angular-animate.js',
        '/framework/javascript/angularjs/angular-sanitize.js',
        '/framework/javascript/angularjs/restangular.js',
        '/framework/javascript/angularjs/kendo.js',
        '/framework/javascript/angularjs/ckeditor.js',
        '/framework/javascript/angularjs/ckeditor-drop.js',
        '/framework/javascript/angularjs/dragdrop.js',
        '/framework/javascript/angularjs/sortable.js',
        '/framework/javascript/angularjs/ng-flow-standalone.min.js',
        '/framework/javascript/angularjs/ng-dialog.min.js'
    ] %>
    <% if additional_js_assets %>
        <% set js_assets = js_assets|merge(additional_js_assets) %>
    <% endif %>

    <!-- PROCESS JAVASCRIPT ASSETS -->
    <% for asset in assets(js_assets) %>
    <script src="<%= asset.getUrlPath() %>"></script>
    <% endfor %>


    <% set angular_modules = [path({"module": "admin", "ngmodule": "app", "resource": "app.js"}, 'angular_resource')] %>

    {# WHAT THE FUCK IS THIS?!?! #}
    <% for module in modules %>
        <% set angular_modules = angular_modules|merge([path({"module": "admin", "ngmodule": module, "resource": "module.js"}, 'angular_resource')]) %>
    <% endfor %>

    <!-- PROCESS ANGULAR MODULES -->
    <% for asset in assets(angular_modules, {"enabled": false}) %>
    <script src="<%= asset.getUrlPath() %>"></script>
    <% endfor %>

    <script>
        WebFont.load({
            google: { families: [
                'Roboto:400,300,300italic,400italic,100,500,500italic,700,700italic:latin,latin-ext',
                'Open+Sans:300,600'
            ] }
        });
    </script>
</head>
<body ng-controller="MainController" flow-prevent-drop flow-drag-enter="dropClass='cf-file-over'" flow-drag-leave="dropClass=''" ng-class="dropClass">

<div class="u-isHiddenVisually">
    <a href="#Content">Skip to content</a>
</div>

<header id="Header" class="Header">

    <section class="BrandingWrap">
        <a ng-href="/{{ language }}/" class="Branding" target="_blank">
            <%= app.config.app.name %>
        </a>
    </section>

    <cf-language-select class="Language dropdown js-dropdownDown"></cf-language-select><!-- /.NavLanguage -->

    <section class="AppInfo">

        {# <a href="<%= path({}, 'admin') %>" class="AppInfo-branding"><%= app.config.app.name %></a> #}

        <h1 class="AppInfo-title" ng-bind="title"></h1>

    </section><!-- /.AppInfo -->

    <section id="Search" class="Search">

        {# <a class="Search-link js-searchLink">
            <i class="fa fa-search"></i>
        </a> #}


        {#<form ng-submit="search(form)" role="search" class="Search-form FormSearch">
            <div class="FormElement FormElement--group">
                <label class="u-isHidden">Search</label>
                <input class="Input Input--small Search-term" placeholder="Enter term(s)" ng-model="form.query" id="form-query">
                <div class="ButtonGroup">
                    <button type="submit" class="Button Button--simple js-showRwdSearch"><i class="fa fa-search"></i></button>
                </div>
            </div>
        </form><!-- /.Search-form -->#}

        <cf-module-search data="dataSourceSearch" />

    </section><!-- /.Search -->

    {#
    <section id="Notification" class="Notification dropdown js-dropdownDown">

        <a href="#" class="Notification-link u-isAlerting">
            <span class="Number c-w">4</span>
            <i class="fa fa-bell"></i>
        </a>

    </section><!-- /.Notification -->
    #}

    <section id="User" class="User dropdown js-dropdownDown" ng-show="currentUser">

        <a class="User-link" data-toggle="dropdown">
            {#
            <span class="User-image">
                <img src="http://placehold.it/30x30" />
            </span>
            #}
            <span class="User-name" ng-bind="currentUser.first_name + ' ' + currentUser.last_name"></span>
            <i class="User-icon fa fa-angle-down"></i>
        </a>

        <ul class="User-navigation NavUser DropdownNav">
            <% for item in user_menu %>

            <li class="NavUser-item">
                <a href="<%= item.url %>"<%= item.target ? ' target="' ~ item.target ~ '"' : '' %><%= (item.onclick ? ' ng-click="' ~ item.onclick ~ '"' : '')|raw %>><%= item.title %></a>
            </li>
            <% endfor %>
        </ul><!-- /.NavUser -->

    </section><!-- /.User -->

</header>


{#
<header id="Header" class="Header">

    <section class="AppInfo">
        <a href="<%= path({}, 'admin') %>" class="AppInfo-branding"><%= app.config.app.name %></a>
        <h1 class="AppInfo-title"><span>Edit</span> Article</h1>
    </section>

    <section id="User" class="User dropdown js-dropdownDown">

        <a class="User-link" data-toggle="dropdown">
            <span class="User-image">
                <img src="http://placehold.it/30x30" />
            </span>
            <span class="User-name" ng-bind="currentUser.first_name + ' ' + currentUser.last_name"></span>
            <i class="User-icon fa fa-angle-down"></i>
        </a>

        <ul class="User-navigation NavUser DropdownNav">
            <% for item in user_menu %>
            <li class="NavUser-item"><a href="<%= item.url %>"<%= item.target ? ' target="' ~ item.target ~ '"' : '' %><%= item.onclick ? ' ng-click="' ~ item.onclick ~ '"' : '' %>><%= item.title %></a></li>
            <% endfor %>
        </ul><!-- /.NavUser -->

    </section><!-- /.User -->
    #}

    {#
    <section id="Notification" class="Notification dropdown js-dropdownDown">

        <a href="#" class="Notification-link u-isAlerting">
            <span class="Number c-w">4</span>
            <i class="fa fa-bell"></i>
        </a>

    </section><!-- /.Notification -->
    #}

    {#
    <section id="Search" class="Search">

        <a class="Search-link js-searchLink">
            <i class="fa fa-search"></i>
        </a>

        <form ng-submit="search(form)" role="search" class="Search-form FormSearch">
            <div class="FormElement FormElement--group">
                <label class="u-isHidden">Search</label>
                <input class="Input Input--small" placeholder="Enter term(s)" ng-model="form.query" id="form-query">
                <span class="ButtonGroup">
                    <button type="submit" class="Button Button--neutral Button--search"><i class="fa fa-search"></i></button>
                </span>
            </div>
        </form><!-- /.Search-form -->

    </section><!-- /.Search -->

</header><!-- /#Header -->
#}

<section id="Navigation" class="Navigation dropdown js-dropdownSlide">

    <a class="Navigation-link" data-toggle="dropdown">
        {#<i class="fa fa-bars"></i>
        <i class="fa fa-times"></i>
        <span class="u-isHiddenVisually">Main navigation</span>#}
        <span class="Bars">
            <i class="Bars-item Bars-item--top"></i>
            <i class="Bars-item Bars-item--middle"></i>
            <i class="Bars-item Bars-item--bottom"></i>
        </span>
    </a>

    <nav class="Navigation-panel DropdownNav">

        <!-- <div class="SelectLang">
            <cf-language-select class="Input Input--small"></cf-language-select>
        </div> -->

        <ul class="NavMain" ng-controller="NavController">

            <% for item in main_menu %>
            <li ng-class="{active:isMenuItemActive('<%= item.url %>')}"><a href="<%= item.url %>"<%= item.target ? ' target="' ~ item.target ~ '"' : '' %>><i class="fa fa-<%= item.icon %>"></i> <%= item.title %></a></li>
            <% endfor %>

        </ul><!-- /.NavMain -->

    </nav><!-- /.Navigation-panel -->

</section><!-- /.Navigation -->

<section id="Content" class="Content with-NavInpage">
    <div class="slide-container" ng-class="navigation.direction">
        <div ng-view class="slide-animation" ng-class="">
        </div>
    </div>
    <noscript>
        <div class="JavascriptNotice">
            <div class="JavascriptNotice-content">
                <h1>No JavaScript support</h1>
                <p>Please enable JavaScript in your browser.</p>
            </div>
        </div>
    </noscript>
</section>

<div class="ContentPreloader">
    <div class="ContentPreloader-inner">
        <i class="ContentPreloader-circle ContentPreloader-circle--1"></i>
        <i class="ContentPreloader-circle ContentPreloader-circle--2"></i>
        <i class="ContentPreloader-circle ContentPreloader-circle--3"></i>
    </div>
</div>

{#
    Inline js

    @todo: prebaciti u file
#}

<script>

// ADD SLIDEDOWN ANIMATION TO DROPDOWN //
  $('.js-dropdownDown').on('show.bs.dropdown', function(e){
    $(this).find('.DropdownNav').first().stop(true, true).slideDown(200);
  });

  // ADD SLIDEUP ANIMATION TO DROPDOWN //
  $('.js-dropdownDown').on('hide.bs.dropdown', function(e){
    $(this).find('.DropdownNav').first().stop(true, true).slideUp(200);
  });

  // ADD SLIDE ANIMATION TO DROPDOWN //
  $('.js-dropdownSlide').on('show.bs.dropdown', function(e){
    $(this).find('.DropdownNav').first().stop(true, true).css({ 'display' : 'block', 'left' : '0' });
    //$('body').addClass('js-showNavigation');
  });

  // ADD SLIDE ANIMATION TO DROPDOWN //
  $('.js-dropdownSlide').on('hide.bs.dropdown', function(e){
    $(this).find('.DropdownNav').first().stop(true, true).css({ 'display' : 'block', 'left' : '-240px' });
    //$('body').removeClass('js-showNavigation');
  });

// ADD  ANIMATION TO RWD SEARCH //
/* @todo: dodati gašenje na click outside
  $('.js-searchLink').on('click', function(e){
    $(this).siblings('.Search-form').stop(true, true).slideToggle(200);
    $(this).parent('.Search').toggleClass('is-visible');
  });
*/

  $('.js-showRwdSearch').on('click', function(e){
    $(this).parents('.Search').toggleClass('is-expanded');
  });

</script>

<script>
    var $buoop = {vs:{i:8,f:15,o:12.1,s:5.1},reminder:0};
    $buoop.ol = window.onload;
    window.onload=function() {
        try {if ($buoop.ol) $buoop.ol();}catch (e) {}
        var e = document.createElement("script");
        e.setAttribute("type", "text/javascript");
        e.setAttribute("src", "//browser-update.org/update.js");
        document.body.appendChild(e);
    }
</script>

</body>
</html>
