coreFramework.service('StaticService', function ($rootScope, Restangular, Message) {
    
    var self = this;
    var _variations;
    var _editorVariations;
    
    Object.defineProperties(this, {
        variations: {
            get: function () {
                if (angular.isUndefined(_variations)) {
                    _variations = [];
                    _editorVariations = [];
                    Restangular.one('variations').get().then(function (response) {
                        angular.forEach(response.data.originalElement, function(item) {
                            if (!item.is_system) {
                                _variations.push(item);
                                if (item.visual_editor) {
                                    _editorVariations.push(item);
                                }
                            }
                        });
                    }, function (errors) {
                        Message.send('Error!', 'error');
                    });
                }
                return _variations;
            },
            enumerable: true
        },
        editorVariations: {
            get: function () {
                self.variations;
                // if (angular.isUndefined(_editorVariations)) {
                //     _editorVariations = [];
                //     Restangular.one('variations').get({ visual_editor: 1 }).then(function (response) {
                //         angular.forEach(response.data.originalElement, function(item) {
                //            _editorVariations.push(item); 
                //         });
                //     }, function (errors) {
                //         Message.send('Error!', 'error');
                //     });
                // }
                return _editorVariations;
            },
            enumerable: true
        }
    });
    
    this.getVariationByCode = function(code) {
        for (var i in _variations) {
            if (_variations[i].code == code) {
                return _variations[i];
            }
        }
        return null;
    }
    
});