coreFramework.service('cfPluralization', function(cfLocale) {
    
    var formulas = {
        'en': function(n) { return n!=1 ? 1 : 0; },
        'hr': function(n) { return n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2; },
        'sl': function(n) { return n%100==1 ? 1 : n%100==2 ? 2 : n%100==3 || n%100==4 ? 3 : 0; },
        'it': function(n) { return n!=1 ? 1 : 0; },
        'bg': function(n) { return n!=1 ? 1 : 0; },
        'cs': function(n) { return n==1 ? 0 : (n>=2 && n<=4) ? 1 : 2; },
        'da': function(n) { return n!=1 ? 1 : 0; },
        'el': function(n) { return n!=1 ? 1 : 0; },
        'et': function(n) { return n!=1 ? 1 : 0; },
        'fr': function(n) { return n>1 ? 1 : 0; },
        'ga': function(n) { return n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4; },
        'hu': function(n) { return n!=1 ? 1 : 0;  },
        'nl': function(n) { return n!=1 ? 1 : 0; },
        'pl': function(n) { return n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2; },
        'sk': function(n) { return n==1 ? 0 : (n>=2 && n<=4) ? 1 : 2; }
    };

    function getFormula(lang) {
        if (lang !== undefined) {
            return formulas[lang];
        } else if (cfLocale.messages && cfLocale.messages in formulas) {
            return formulas[cfLocale.messages];
        } else {
            return formulas['en'];
        }
    }

    function pluralize(array, n, lang) {
        var output = array[0];
        var arrayIndex = getFormula(lang)(n);
        
        if (arrayIndex <= array.length-1) {
            output = array[arrayIndex];
        }

        return output
                .replace('\%d', n)
                .replace('\%1\$d', n)
                .replace('\%s', n)
                .replace('\%1\$s', n);
    }

    this.pluralize = pluralize;

});
