coreFramework.provider('Navigation', function () {
    var _modules = {};
    var _feature;

    this.setConfig = function (params) {
        angular.extend(_modules, params);
    };

    this.$get = ['$location', '$route', '$rootScope', function ($location, $route, $rootScope) {

        function getPathParts() {
            var parts = $location.url().split('/');
            for (var i = 0; i < parts.length; i++) {
                if (!parts[i]) {
                    parts.splice(i, 1);
                    i--;
                }
            }
            return parts;
        }

        return {
            setFeature: function(title) {
                _feature = title;
            },
            getFeature: function() {
                return {
                    title: _feature,
                    url: getPathParts()[2]
                }
            },
            getModule: function() {
                var module = getPathParts()[2];
                return {
                    title: _modules[module],
                    url: module
                }
            },
            getMenu: function() {
                return _modules;
            },
            getTitle: function() {
                return this.getFeature().title + ' - ' + this.getModule().title;
            },
            getCrumbs: function() {
                return ''; //'<a href="/admin/' + this.getModule().url + '/'">this.getFeature().title + ' - ' + ;
            }
        };

    }];
});
