coreFramework.provider('Language', function () {
    var config = {
        languages: [],
        defaultLanguage: null,
        storeItemId: 'cfLanguage'
    };

    this.setConfig = function (params) {
        angular.extend(config, params);
    };

    this.$get = ['$route', '$rootScope', function ($route, $rootScope) {

        var savedLanguage = localStorage.getItem(config.storeItemId);
        if (savedLanguage) {
            angular.forEach(config.languages, function (language) {
                if (language.id == savedLanguage) {
                    $rootScope.language = savedLanguage;
                }
            });
        }
        if (!$rootScope.language && config.defaultLanguage) {
            $rootScope.language = config.defaultLanguage;
            localStorage.setItem(config.storeItemId, config.defaultLanguage);
        }

        return {
            set: function (language) {
                $rootScope.language = language;
                localStorage.setItem(config.storeItemId, language);
                $route.reload();
            },
            get: function () {
                return $rootScope.language;
            },
            getAll: function () {
                return config.languages;
            },
            getConfig: function () {
                return config;
            }
        };

    }];
});
