coreFramework.provider('Heartbeat', function () {
    var config = {
        interval: 1000 * 60 * 10, // 10 minutes
        url: ''
    };
    var heartbeatInterval;

    this.setConfig = function (params) {
        angular.extend(config, params);
    };

    this.$get = ['$http', '$interval', function ($http, $interval) {

        return {
            start: function () {
                if (!config.url) throw new Error('Heartbeat.start: url not set');

                heartbeatInterval = $interval(function () {
                    $http.get(config.url);
                }, config.interval);
            },
            stop: function () {
                $interval.cancel(heartbeatInterval);
            },
            getConfig: function () {
                return config;
            }
        };

    }];
});
