coreFramework.service('AssignmentService', function($rootScope) {
    
    var _list,
        _output
        _blank = 'defaultBlankKey';
    
    this.STATE = 'assigned';
    this.STATIC = 'static';
    
    this.add = function add(type, name, value) {
        if (angular.isUndefined(_list[type])) _list[type] = {};
        if (name) {
            _list[type][name] = value;
        } else {
            _list[type][_blank] = value;
        }
        _output = renderOutput();
    };
    
    function renderOutput() {
        
        var listById = {},
            listCopy = angular.copy(_list),
            list = {},
            name;
        
        angular.forEach(listCopy, function(item, type) {
            listById[type] = {};
            list[type] = [];
            angular.forEach(item, function(value, name) {
                if (!angular.isArray(value)) {
                    value = [value];
                }
                angular.forEach(value, function(entity) {
                    if (entity) {
                        if (entity.id) {
                            if (angular.isUndefined(listById[type][entity.id])) {
                                entity.assignedTo = [];
                                listById[type][entity.id] = entity;
                            }
                            if (name != _blank) {
                                listById[type][entity.id].assignedTo.push(name);
                            }
                        } else {
                            if (name != _blank) {
                                entity.assignedTo = [name];
                            }
                            list[type].push(entity);
                        }
                    }
                });
            });
            angular.forEach(listById[type], function(entity) {
                list[type].push(entity);
            });
            if (list[type].length == 0) {
                delete list[type];
            }
        });
        
        return list;
        
    };
    
    this.getList = function getList(type) {
        if (angular.isUndefined(_output[type])) {
            return [];
        }
        return _output[type];
    };
    
    this.reset = function reset() {
        _list = {};
        _output = {};
    };
    
    this.reset();
    
});
