coreFramework.provider('AssignmentMediator', function () {

    var insertMethod;
    var insertType;
    var insertElement;
    var insertChange;

    return {
        $get: ['Message', function (Message) {
            var obj = {
                send: function (data, type) {
                    if (insertMethod && insertType) {
                        if (insertType != type) {
                            console.error('AssignmentMediator: type does not match ' + insertType + '!');
                            Message.send('Destination requires type format of ' + insertType + '!', 'error');
                            return;
                        }
                        insertMethod(data, type);
                    } else {
                        console.error('AssignmentMediator: pick a target first');
                    }
                },
                register: function (method, type, element) {
                    insertType = type;
                    insertElement = element;
                    insertChange = Math.random();
                    if (typeof method === 'function') {
                        insertMethod = method;
                    } else {
                        console.error('AssignmentMediator: target must be a function');
                    }
                }
            };
            Object.defineProperties(obj, {
                type: {
                    get: function () {
                        return insertType;
                    },
                    enumerable: true
                },
                element: {
                    get: function () {
                        return insertElement;
                    },
                    enumerable: true
                },
                change: {
                    get: function () {
                        return insertChange;
                    },
                    enumerable: false
                }
            });
            return obj;
        }]
    };
});
