coreFramework.service('AnimationService', function ($q, $timeout) {

    var self = this;
    var data = {};

    self.add = function (animationName) {
        if (data[animationName]) {
            data[animationName].reject();
        }
        data[animationName] = $q.defer();
    };

    self.remove = function (animationName) {
        if (data[animationName]) {
            data[animationName].resolve();
            delete data[animationName];
        }
    };

    self.kill = function (animationName) {
        if (data[animationName]) {
            data[animationName].reject();
            delete data[animationName];
        }
    };

    self.get = function (animationName) {

        var deferred = $q.defer();

        $timeout(function () {
            if (data[animationName]) {
                data[animationName].promise.then(function () {
                    deferred.resolve();
                });
            } else {
                deferred.resolve();
            }
        });

        return deferred.promise;

    };

    self.getAll = function () {

        var all = [];

        angular.forEach(arguments, function (animationName) {
            all.push(self.get(animationName));
        });

        return $q.all(all);

    };

});