coreFramework.filter('url', function () {
    function tokenize(tpl) {
        var tokens = tpl.split('/');

        tokens.forEach(function (value, index) {
            if (value === '') {
                tokens.splice(index, 1);
            }
        });

        return tokens;
    }

    function fillValues(tokens, data) {
        tokens.forEach(function (value, index) {
            var key = value.replace(':', '');

            if (value.charAt(0) === ':') {
                if (data[key]) {
                    tokens[index] = data[key];
                } else {
                    tokens.splice(index, 1);
                }
            }
        });

        return tokens;
    }

    function build(tokens) {
        return '/' + tokens.join('/') + '/';
    }

    return function (data, tpl) {
        var tokens = tokenize(tpl);
        fillValues(tokens, data);
        return build(tokens);
    };
});