coreFramework.filter('cfCurrency', function ($filter, cfLocale) {
    return function (input, currencyCode, languageCode, round) {

        var decimals = round || 2;

        var currencySymbols = {
            'BAM': 'BAM',
            'CZK': 'CZK',
            'EUR': '€',
            'GBP': '£',
            'HRK': 'HRK',
            'HUF': 'HUF',
            'PLN': 'PLN',
            'RSD': 'RSD',
            'USD': '$',
        };

        var symbol = '€';

        if (currencyCode) {
            symbol = currencySymbols[currencyCode] || currencyCode;
        }

        if (angular.isUndefined(input) || input == '') {
            return '';
        }

        var language = 'en';
        var currency = 'eur';

        if (languageCode) {
            language = angular.lowercase(languageCode);
        } else if (cfLocale.messages) {
            language = angular.lowercase(cfLocale.messages);
        }

        if (currencyCode) {
            currency = angular.lowercase(currencyCode);
        } else if (cfLocale.monetary) {
            currency = angular.lowercase(cfLocale.monetary);
        }

        var options = {
            style: "currency",
            currency: currency,
            minimumFractionDigits: decimals,
            maximumFractionDigits: decimals,
            // currencyDisplay: 'symbol'
        };

        if (language == 'en' && currency == 'hrk') {
            // return 'HRK ' + $filter('number')(input, 2);
            return 'HRK ' + (+input).toLocaleString(language, { minimumFractionDigits: decimals, maximumFractionDigits: decimals });
        }
        try {
            var output = parseFloat(input).toLocaleString(language, options);
            output = output.replace('¤', currencyCode + ' ');
            if (/^[\d\s\.]+$/.test(output)) {
                output = output.replace(/\d(?=(\d{3})+\.)/g, '$&,');
            }
            if (/^[\d\s\.\,]+$/.test(output)) {
                output += ' ' + symbol;
            }
            return output;
        } catch (err) {
            var output = (+input).toLocaleString(language, { minimumFractionDigits: decimals, maximumFractionDigits: decimals });
            output = output.replace('¤', currencyCode + ' ');
            if (/^[\d\s\.]+$/.test(output)) {
                output = output.replace(/\d(?=(\d{3})+\.)/g, '$&,');
            }
            if (/^[\d\s\.\,]+$/.test(output)) {
                output += ' ' + symbol;
            }
            return output;
            
            // if (language == 'hr') {
            //     return $filter('number')(input, decimals).replace(/(\,)(.*)(\.)/gi,'$3$2$1');
            // } else {
            //     return $filter('number')(input, decimals);
            // }
            // return parseFloat(input).toFixed(decimals);
        }
    }
});