coreFramework.directive('cfWidgetCollection', function (AssignmentMediator) {
    return {
        restrict: 'E',
        replace: true,
        transclude: true,
        require: 'form',
        scope: {
            list: '=ngModel',
            errors: '=',
            preview: '=?',
            listName: '@listName'
        },
        template:   '<div class="cf-widget-collection" ng-form="form">' +
                        '<style>.ui-sortable-placeholder { visibility: visible !important; background: #f7f7f7; border: 1px dashed #1381d6; }</style>' +
                        '<div class="js-sortable-items" ng-model="list" ui-sortable="sortableOptions">' +
                            //'<div ng-repeat="item in list track by $index">' +
                                '<cf-widget-collection-item preview="preview" ng-form="form" style="margin-bottom: 0;" ng-repeat="item in list track by $index" ng-model="item" data-index="{{ $index }}" class="cf-widget-collection-item Widget js-sortable-item Sortable-item"></cf-widget-collection-item>' +
                            //'</div>' +
                        '</div>' +
                        '<div class="Droparea Droparea--widget" ng-class="{\'is-focused\': isFocused}">' +
                            '<div class="Droparea-item">' +
                                '<a href="" ng-click="register()" class="Button">Add widget</a>' +
                                '<span class="Droparea-description">select widget from repository</span>' +
                            '</div>' +
                        '</div>' +
                    '</div>',
        controller: ['$scope', function ($scope) {
            
            $scope.preview = angular.isDefined($scope.preview) ? $scope.preview : true;

            // console.log('cfWidgetCollection', $scope.$id, $scope.$parent.$id, $scope.$parent);
            $scope.sortableOptions = {
                axis: 'y',
                //items: '> .js-sortable-items > .js-sortable-item',
                handle: '.js-sortable-handle'
            };

            $scope.getNextUniqueID = function () {
                var id = -1;

                angular.forEach($scope.list, function (item) {
                    if (item.selector) {
                        id = Math.max(id, parseInt(item.selector.replace($scope.listName + '-', ''), 10));
                    }
                });

                return id + 1;
            };

            // $scope.register = function () {
            //     AssignmentMediator.register($scope.addItem, 'widget');
            // };
        }],
        link: function (scope, element, attrs, ctrl) {

            scope.register = function () {
                AssignmentMediator.register(scope.addItem, 'widget', element);
            };
            scope.$watch(function () {
                return AssignmentMediator.element;
            }, function (value) {
                scope.isFocused = element == AssignmentMediator.element;
            });
            scope.$watch('list', function (value, oldValue) {
                if (oldValue) {
                    ctrl.$setDirty();
                }
            }, true);

            scope.addItem = function (obj) {
                scope.list = scope.list || [];
                scope.list.push(angular.copy(obj));
                ctrl.$setDirty();
            };

            scope.removeItem = function (index) {
                if (confirm('Are you sure you want to remove this widget?')) {
                    scope.list.splice(index, 1);
                    ctrl.$setDirty();
                }
            };

            element.on('dragover', function (e) {
                if (e.originalEvent) e = e.originalEvent;
                if (e.preventDefault) e.preventDefault();
                return false;
            });

            element.on('dragenter', function (e) {
                if (e.originalEvent) e = e.originalEvent;
                if (e.preventDefault) e.preventDefault();
                return false;
            });

            element.on('drop', function (e) {
                if (e.originalEvent) e = e.originalEvent;
                if (e.preventDefault) e.preventDefault();

                var data = e.dataTransfer.getData('widget');

                try {
                    data = JSON.parse(data);
                } catch (e) {
                    data = null;
                }

                if (data) {
                    scope.$apply(function() {
                        scope.addItem(data);
                    });
                }

                return false;

            });
        }
    };
});



coreFramework.directive('cfWidgetCollectionItem', function ($compile) {
    return {
        restrict: 'EA',
        replace: true,
        scope: {
            widget: '=ngModel',
            preview: '=?'
        },
        controller: ['$scope', '$element', function ($scope, $element) {
            // console.log('---- cfWidgetCollectionItem scope', $scope);
            $scope.widget.config = $scope.widget.config || {};
            $scope.widget.config.is_active = $scope.widget.config.is_active || false;
            $scope.widget.selector = $scope.widget.selector || ($scope.$parent.listName + '-' + $scope.$parent.getNextUniqueID());
            $scope.widget.selector = $scope.widget.selector.replace(/.*\-([^-]*?)$/, $scope.$parent.listName + '-' + '$1');
            // delete $scope.widget.is_dirty;
            // $scope.widget.is_dirty = true;

            $scope.$watch(function () {
                if (angular.isDefined($scope.form)) {
                    return $scope.form.$dirty;
                }
                return null;
            }, function (value) {
                if (value) {
                    $scope.widget.is_dirty = true;
                    //$scope.form.$setPristine();
                }
            });

            $scope.editMode = false;
            $scope.instantiated = false;

            $scope._removeWidget = function () {
                console.log('removing widget from', $scope.$parent);
                $scope.$parent.removeItem($element.data('index'), 1);
            };
            $scope._toggleMode = function () {
                $scope.editMode = !$scope.editMode;
                $scope.instantiated = true;
            };
            $scope._expandWidget = function () {
                $scope.editMode = true;
                $scope.instantiated = true;
            };
            $scope._generateTemplate = function(type, is_active) {
                var template =  '<div ng-form="form">' +
                                    '<div ng-style="preview ? { width: \'80%\' } : { width: \'100%\' }" style="vertical-align: top; display: inline-block; position: relative;">' +
                                        '<span class="Widget-type">' + type + '</span>' +
                                        '<cw-widget-' + type + ' class="Widget-content" ng-form="form"></cw-widget-' + type + '>' +
                                        '<div class="Widget-tools">' +
                                            '<span class="Tool-status">' +
                                                //'<input type="hidden" ng-model="widget.config.is_active">' +
                                                '<a class="Widget-visibilityAction" ng-class="{\'is-hidden\': !widget.config.is_active}" ng-click="widget.config.is_active = !widget.config.is_active">Visible</a></span>' +
                                            '<span class="Tool-sort"><a href class="js-sortable-handle"><i class="fa fa-arrows-v"></i></a></span>' +
                                            '<span class="Tool-delete"><a ng-click="_removeWidget()"><i class="fa _fa-ellipsis-v fa-trash-o"></i></a></span>' +
                                            '<span class="Tool-toggle"><a ng-click="_toggleMode()"><i class="fa fa-pencil"></i></a></span>' +
                                        '</div>' +
                                    '</div>' +
                                    '<div ng-if="preview" style="width: 20%; background: #fff; display: inline-block;">' +
                                        '<div ng-if="widget.preview" style="max-height: 250px; overflow: hidden; display: inline-block;"><img ng-src="{{ widget.preview }}" width="100%" /></div>' +
                                        '<div ng-if="!widget.preview" style="background: #fff; text-transform: uppercase; text-align: center; min-height: 64px; line-height: 64px;"><span style="width: 100%;">No preview yet!</span></div>' +
                                    '</div>' +
                                '</div>';
                return template;
            };
            $scope.processForm = function () {
                console.log('processForm');
            };
            $scope.$watch('widget.type', function (newValue, oldValue) {
                if (newValue == oldValue) {
                    return;
                }
                // var template =  $scope._generateTemplate($scope.widget.type, $scope.widget.config.is_active);
                var template =  $scope._generateTemplate($scope.widget.type);

                $scope.editMode = false;
                $scope.instantiated = false;
                $element.html(template).show();
                $compile($element.contents())($scope);
            });
        }],
        compile: function(element, attrs) {
            return function(scope, element, attrs) {
                // console.log('widget compile', scope);
                // var template =  scope._generateTemplate(scope.widget.type, $scope.widget.config.is_active);
                var template =  scope._generateTemplate(scope.widget.type);

                element.html(template).show();
                $compile(element.contents())(scope);
            };
        }
    };
});
