coreFramework.directive('cwRelated', function () {
    return {
        restrict: 'E',
        require: 'ngModel',
        replace: true,
        scope: {
            data: '=ngModel',
            type: '@cfContentType',
            min: '@',
            max: '@'
        },
        template:   '<div class="cw-related">' +
                        '<cw-related-item ng-repeat="item in toArray(data)"></cw-related-item>' +
                        '<div class="cw-related-request" ng-if="(toArray(data).length < max) || (!max)"><a href="#" class="Button" ng-click="setFocus()">Add image</a></div>' +
                    '</div>',
        link: function (scope, element, attrs, ctrl) {

            function minValidate(value) {
                if ((attrs.ngRequired === 'true' || scope.min > 0) && scope.toArray(value).length < Math.max(1, scope.min)) {
                    return false;
                }
                return true;
            }

            scope.$watch(function() {
                return ctrl.$modelValue;
            }, function(modelValue, oldValue) {
                ctrl.$setValidity('min', minValidate(modelValue));
            }, true);

            scope.setDirty = function() {
                ctrl.$dirty = true;
                ctrl.$pristine = false;
            }

        },
        controller: ['$scope', 'AssignmentMediator', function ($scope, AssignmentMediator) {

            $scope.toArray = function(obj) {
                if (obj) {
                    return angular.isArray(obj) ? obj : [obj];
                } else {
                    return [];
                }
            }

            $scope.setFocus = function() {
                AssignmentMediator.register($scope.add, $scope.type);
            }

            $scope.add = function (item) {

                if ($scope.max == 1) {
                    if (!$scope.data) {
                        $scope.data = item;
                        $scope.setDirty();
                    }
                } else {
                    $scope.data = $scope.toArray($scope.data);
                    if ($scope.max && $scope.data.length >= $scope.max) {
                        //console.error('ne može više, previše slika');
                    } else {

                        if ($scope.data.map(function(item){ return item.id; }).indexOf(item.id) == -1) {
                            $scope.data.push(item);
                            $scope.setDirty();
                        }
                    }
                }

                //$scope.$apply();

            };
            $scope.remove = function (id) {

                if ($scope.max == 1) {
                    if ($scope.data.id === id) {
                        $scope.data = null;
                        $scope.setDirty();
                    }
                } else {
                    for (var i = 0; i < $scope.data.length; i++) {
                        if ($scope.data[i].id === id) {
                            $scope.data.splice(i, 1);
                            $scope.setDirty();
                            break;
                        }
                    }
                }

            };
            $scope.replace = function (id) {
                console.log('related replace', id);
            };
            $scope.edit = function (id) {
                console.log('related edit', id);
            };

        }]
    };
});
coreFramework.directive('cwRelatedItem', function ($compile) {
    return {
        restrict: 'E',
        replace: true,
        scope: true,
        require: '^cwRelated',
        controller: ['$scope', function ($scope) {

            $scope.remove = function(id) {
                $scope.$parent.remove(id);
            }

        }],
        compile: function(element, attrs) {

            return function(scope, element, attrs) {

                var template =  '<div class="cw-related-item">' +
                                    '<cw-item-' + scope.type + '></cw-item-' + scope.type + '>' +
                                    '<div class="cw-related-item-tools">' +
                                        '<a ng-click="remove(item.id)" class="cw-related-item-remove"><i class="fa fa-times"></i><span class="u-isHiddenVisually">Delete</span></a>' +
                                    '</div>' +
                                '</div>';

                element.html(template).show();
                $compile(element.contents())(scope);

            }

        }
    }
});