coreFramework.directive('cfGoogleAutocomplete', function () {
    return {
        restrict: 'A',
        scope: {
            ngModel: '=cfGoogleAutocomplete'
        },
        controller: ['$scope', '$attrs', function ($scope, $attrs) {

        }],
        link: function (scope, element, attrs) {

            if ( typeof scope.ngModel == 'undefined' || scope.ngModel.length==0 ) {
                    scope.ngModel = "45.8167, 15.9833, 2";
            }

            var autocomplete = new google.maps.places.Autocomplete(element[0]);

            google.maps.event.addListener(autocomplete, 'place_changed', function() {

                var place = autocomplete.getPlace();
                if (!place.geometry) {
                    return;
                }

                var loc = place.geometry.location;

                loc = loc.k+', '+loc.A;

//                console.log(scope);//scope.data.map_location = loc;

                scope.$apply(function () {
                    old_loc = scope.ngModel.split(', ');
                    if (typeof old_loc[2] != 'undefined') {
                        scope.ngModel = loc+', '+old_loc[2];
                    } else {
                        scope.ngModel = loc;
                    }
                });

            });

        }
    };
});