coreFramework.directive('cwList', function () {
    return {
        restrict: 'E',
        scope: {
            data: '=ngModel',
            url: '@',
            contentType: '@'
        },
        template: function (element, attrs) {
            // FIXME: content templates should not be hardcoded here
            var tpl = "<div kendo-list-view k-data-source='dataSource' k-template=\"{TPL}\"></div>" +
                    "<div kendo-pager k-data-source='dataSource' k-button-count='5' k-refresh='true'></div>";
            var types = {
                image : "\'<a href class=\\'js-assign\\'><img src=\\'#=variations.admin_small.url#\\'></a>\'"
            };

            return tpl.replace('{TPL}', types[attrs.contentType]);
        },
        controller: ['$scope', 'AssignmentMediator', 'Restangular', function ($scope, AssignmentMediator, Restangular) {
            
            $scope.count = 0;
            $scope.dataSource = new kendo.data.DataSource({
                transport: {
                    read : function (options) {
                        var params = { 'offset': options.data.skip, 'limit': options.data.pageSize };
                        angular.extend(params, { order_by: 'created_at desc' });
                        // angular.extend(params, $scope.form);
                        // console.log('options', options.data);
                        // console.log('transport params', params);
                        Restangular.oneUrl('repository', $scope.url).get(params).then(function (response) {
                            // console.log('repository response', response);
                            $scope.count = response.headers()['x-metadata-count'];
                            options.success(response.data.originalElement);
                        });
                    }
                },
                schema: {
                    total: function (response) {
                        return $scope.count;
                    }
                },
                pageSize: 10,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true
            });

            this.assign = function (uid) {
                var model = this.getModelByUid(uid);
                AssignmentMediator.send(model, $scope.contentType);
            };
            this.getModelByUid = function (uid) {
                return $scope.dataSource.getByUid(uid);
            };

        }],
        link: function (scope, element, attrs, ctrl) {
            element.on('click', '.js-assign', function (e) {
                ctrl.assign(this.getAttribute('data-uid'));
                e.preventDefault();
            });
        }
    };
});
coreFramework.directive('cwListBkp', function () {
    return {
        restrict: 'E',
        scope: {
            data: '=ngModel',
            url: '@',
            contentType: '@'
        },
        template: function (element, attrs) {
            // FIXME: content templates should not be hardcoded here
            var tpl = "<div kendo-list-view k-data-source='dataSource' k-template=\"{TPL}\"></div>" +
                    "<div kendo-pager k-data-source='dataSource' k-button-count='5' k-refresh='true'></div>";
            var types = {
                image : "\'<a href class=\\'js-assign\\'><img src=\\'#=variations.admin_small.url#\\'></a>\'"
            };

            return tpl.replace('{TPL}', types[attrs.contentType]);
        },
        controller: ['$scope', 'AssignmentMediator', 'Restangular', function ($scope, AssignmentMediator, Restangular) {
            
            $scope.count = 0;
            $scope.dataSource = new kendo.data.DataSource({
                transport: {
                    read : function (options) {
                        var params = { 'offset': options.data.skip, 'limit': options.data.pageSize };
                        angular.extend(params, { order_by: 'created_at desc' });
                        // angular.extend(params, $scope.form);
                        // console.log('options', options.data);
                        // console.log('transport params', params);
                        Restangular.oneUrl('repository', $scope.url).get(params).then(function (response) {
                            // console.log('repository response', response);
                            $scope.count = response.headers()['x-metadata-count'];
                            options.success(response.data.originalElement);
                        });
                    }
                },
                schema: {
                    total: function (response) {
                        return $scope.count;
                    }
                },
                pageSize: 10,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true
            });

            this.assign = function (uid) {
                var model = this.getModelByUid(uid);
                AssignmentMediator.send(model, $scope.contentType);
            };
            this.getModelByUid = function (uid) {
                return $scope.dataSource.getByUid(uid);
            };

        }],
        link: function (scope, element, attrs, ctrl) {
            element.on('click', '.js-assign', function (e) {
                ctrl.assign(this.getAttribute('data-uid'));
                e.preventDefault();
            });
        }
    };
});
