coreFramework.directive('cfLanguageSelect', function () {
    return {
        restrict: 'EA',
        replace: true,
        scope: {},
        template:   '<section id="Language" ng-if="languages.length > 1">'+
                        '<a class="Language-link" data-toggle="dropdown">'+
                            '<span class="Language-name">{{ language }}</span>'+
                            '<i class="Language-icon fa fa-angle-down"></i>'+
                        '</a>'+
                        '<ul class="Language-navigation NavLanguage DropdownNav">' +
                            '<li ng-repeat="item in languages" ng-class="{active: item.id == language}">' +
                                '<a href="" ng-click="changeLanguage(item.id)">{{ item.title }}</a>' +
                            '</li>' +
                        '</ul>'+
                    '</section>',
        controller: ['$rootScope', '$scope', 'Language', function ($rootScope, $scope, Language) {
            
            $rootScope.$watch('language', function (value) {
                $scope.language = value;
            });
            
            $scope.languages = Language.getAll();

            $scope.changeLanguage = function (language) {
                if (language != $scope.language) {
                    Language.set(language);
                }
            };

        }]
    };
});






coreFramework.directive('cfLanguageSelectOld', function () {
    return {
        restrict: 'EA',
        replace: true,
        scope: {},
        template:   '<ul class="cf-language-select">' +
                        '<li ng-repeat="(key, value) in languages" ng-class="{active: key == language}">' +
                            '<a href="" ng-click="changeLanguage(key)">{{ value }}</a>' +
                        '</li>' +
                    '</ul>',
        controller: ['$scope', 'Language', function ($scope, Language) {
            $scope.language = Language.get();
            $scope.languages = Language.getAll();

            $scope.changeLanguage = function (lang) {
                Language.set(lang);
            };
        }],
        link: function (scope, element, attrs, ctrl) {}
    };
});
