coreFramework.provider('ItemTypes', function () {

    var _itemTypes = {
        article:    { directive: 'cf-item-article' },
        product:    { directive: 'cf-item-product' },
        recipe:     { directive: 'cf-item-recipe', buttons: { edit: false } },
        file:       { directive: 'cf-item-article', params: { uploader: true } },
        image:      { directive: 'cf-item-image', params: { uploader: true } },
        widget:     { directive: 'cf-item-widget' },
        ingredient: { directive: 'cf-item-ingredient', buttons: { edit: false } },
        coolarticle:{ directive: 'cf-item-coolarticle', buttons: { edit: false } },
        coolbook:   { directive: 'cf-item-coolbook', buttons: { edit: false } }
    };

    this.setType = function (type, directive, params) {
        if (!(type && directive)) {
            console.log('Content type and directive name must be defined!');
            return;
        }
        _itemTypes[type] = angular.extend({ directive: directive }, params);
    };

    this.$get = function () {

        return {
            get: function(type) {
                if (!_itemTypes[type]) {
                    console.log('Type "' + type + '" is not defined, "Article" is returned instead.');
                    type = 'article';
                }
                return _itemTypes[type];
            }
        };

    };

});

coreFramework.service('ItemTypesBkp', function () {

    var _itemTypes = {
        article:    'cf-item-article',
        product:    'cf-item-product',
        file:       'cf-item-article',
        image:      'cf-item-image',
        widget:     'cf-item-widget'
    };

    this.get = function(type) {
        if (angular.isDefined(_itemTypes[type])) {
            return _itemTypes[type];
        }
        console.log('Type "' + type + '" is not defined, "Article" is returned instead.');
        return _itemTypes['article'];
    }

});

coreFramework.directive('cfItemWidget', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="Widget">{{ item.title }}</div>'        
    };
});

coreFramework.directive('cfItemImage', function (Restangular) {
    return {
        restrict: 'E',
        replace: true,
        scope: true,
        template:   '<span class="Image">' +
                        //'<img ng-if="image_url" ng-src="{{ image_url }}" title="{{ item.id }}" />' +
                        '<span class="img" ng-if="image_url" style="display: block; background: url({{ image_url }}) no-repeat 50% 50%; background-size: cover;"></span>' +
                        '<span ng-if="item.rawFile" style="display: block; width: 145px; height: 145px; background: url({{ item.snapshot }}) no-repeat 50% 50%; background-size: cover;">' +
                            '<span style="display: block; width: 100%; height: 100%; background-color: rgba(255, 255, 255, .5);">' +
                                '<span style="display: block; width: {{ 100 - item.progress }}%; height: 100%; float: right; background-color: rgba(19, 129, 214, .75);"></span>' +
                            '</span>' +
                        '</span>' +
                        '<span ng-if="!image_url && !item.rawFile">no image</span>' +
                        // '<span class="Image-tools u-cf">' +
                        //     '<a href="" class="Image-toolPreview"><i class="fa fa-search"></i><span class="u-isHiddenVisually">Preview</span></a>' +
                        //     '<a href="" class="Image-toolEdit"><i class="fa fa-pencil"></i><span class="u-isHiddenVisually">Edit</span></a>' +
                        // '</span>' +
                    '</span>',
        controller: ['$scope', function($scope) {

            var defaultVariation = $scope.defaultVariation || 'admin_small';

            if ( angular.isUndefined( $scope.imageVariation ) ) {
                $scope.imageVariation = defaultVariation;
            }

            $scope.$watch('item', function() {
                // console.log('cfItemImage', $scope.item);
                if ($scope.item) {
                    if ($scope.item.id && angular.isUndefined($scope.item.variations)) {
                        Restangular.one('images', $scope.item.id).get({'select': ['Variations.*']}).then(function (response) {
                            $scope.item = response.data.originalElement;
                        }, function (error) {
                        });
                    }
                    if ( angular.isDefined( $scope.item.variations ) ) {
                        if (angular.isDefined($scope.item.variations[$scope.imageVariation])) {
                            $scope.image_url = $scope.item.variations[$scope.imageVariation].url;
                        } else if (angular.isDefined($scope.item.variations[defaultVariation])) {
                            $scope.image_url = $scope.item.variations[defaultVariation].url;
                        }
                    }
                }
            }, true);
        }],
        link: function(scope, element, attrs) {
            if (attrs.item) {
                scope.item = scope.$eval(attrs.item);
            }
            scope.$watch(function () { return attrs.src; }, function (value) {
                // if (scope.item) {
                    if (angular.isDefined(value)) {
                        // console.log('attrs.src loaded');
                        scope.image_url = value;
                    }
                // }
            });
        }
    };
});
coreFramework.directive('cfItemImages', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<img class="Image" ng-src="{{ item.variations.admin_small.url }}" title="{{ item.id }}" />'
    };
});

coreFramework.directive('cfItemUser', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemProduct', function () {
    return {
        restrict: 'E',
        replace: true,
        // template:   '<div class="tmp-itemInfo"><cf-item-image item="item.cover_image"></cf-item-image> {{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
        template:   '<div class="tmp-itemInfo">' +
                        // '<cf-item-image item="{ id: item.header_image_id }"></cf-item-image>' +
                        '{{ item.title }}' +
                        '<span class="tmp-itemID fs-s">ID {{ item.id }}</span>' +
                        // 'header_image_id: {{ item.header_image_id }} <br />' +
                    '</div>'
    };
});
coreFramework.directive('cfItemRecipe', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemIngredient', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemCoolarticle', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemCoolbook', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemArticle', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemFile', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div class="tmp-itemInfo">{{item.title}} <span class="tmp-itemID fs-s">ID {{ item.id }}</span></div>'
    };
});
coreFramework.directive('cfItemSitemap', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div style="width: 300px;">{{ item.id }} | {{item.title}}</div>',
        controller: ['$scope', function ($scope) {

            console.log($scope.item);

        }]
    };
});
coreFramework.directive('cfItemVariation', function () {
    return {
        restrict: 'E',
        replace: true,
        template:   '<div style="width: 300px;">{{ item.id }} | {{item.name}}</div>',
        controller: ['$scope', function ($scope) {

            console.log($scope.item);

        }]
    };
});