coreFramework.directive('cfCropper', function () {
    return {
        restrict : 'E',
        replace: true,
        scope : {
            source: '=',
            variation: '=',
            variations: '=',
            crop: '='
        },
        template:   '<div>' +
                        // '<img ng-src="{{ image.variations.admin_editor.url + \'?v=\' + image.updated_at.replace(\' \', \'|\') }}" width="{{ image.variations.admin_editor.width }}" height="{{ image.variations.admin_editor.height }}">' +
                        '<img ng-src="{{ image.variations.admin_editor.url }}" width="{{ image.variations.admin_editor.width }}" height="{{ image.variations.admin_editor.height }}">' +
                    '</div>',
        controller: ['$scope', 'DataService', 'StaticService', 'Restangular', 'Message', function($scope, DataService, StaticService, Restangular, Message) {

            //$scope.variations = StaticService.variations;

            $scope.getAspectRatio = function () {
                var aspectRatio;
                var variation = StaticService.getVariationByCode($scope.variation);
                if (variation != null && variation.resize_type === 'fill') {
                    aspectRatio = variation.width / variation.height;
                } else if (variation != null && variation.resize_type === 'fit') {
                    aspectRatio = 0;
                } else {
                    aspectRatio = $scope.image.width / $scope.image.height;
                }

                return aspectRatio;
            };

            $scope.selected = function (params) {
                angular.extend($scope.crop, params);
                //$scope.crop = params;
                /*
                Restangular.oneUrl('crop', $scope.source.api + $scope.image.id + '/variations/').patch(params).then(function (response) {
                    Message.send('Image crop saved', 'success', 2);
                }, function (error) {
                    Message.send(error.data, 'error');
                });
                */
            }
        }],
        link: function(scope, element, attrs) {

            scope.$watch('[source.data, variations, variation]', function() {
                //console.log(scope.source.data.id, scope.variations.length, scope.variation);
                if (angular.isDefined(scope.source.data) && angular.isDefined(scope.source.data.id) && scope.variations.length) {
                    element.find('img').bind('load', function(e){
                        Jcrop_init();
                    });
                    scope.image = scope.source.data;
                }
            }, true);
            scope.$watch('variation', function() {
                if (angular.isDefined(scope.cropApi)) {
                    Jcrop_init();
                }
            });

            function Jcrop_init() {
                element.find('img').attr('style', null);
                if (angular.isDefined(scope.cropApi)) {
                    scope.cropApi.destroy();
                }
                if (angular.isUndefined(scope.image.variations[scope.variation])) {
                    scope.image.variations[scope.variation] = {};
                }
                var variationData = scope.image.variations[scope.variation];
                var firstTry = true;
                element.find('img').Jcrop({
                    aspectRatio: scope.getAspectRatio(),
                    setSelect: [
                        parseInt(variationData.crop_x, 10), // x1
                        parseInt(variationData.crop_y, 10), // y1
                        parseInt(variationData.crop_width, 10) + parseInt(variationData.crop_x, 10), // x2
                        parseInt(variationData.crop_height, 10) + parseInt(variationData.crop_y, 10) //y2
                    ],
                    trueSize: [scope.image.width, scope.image.height],
                    onSelect: function (data) {
                        if (!firstTry) {
                            variationData = scope.image.variations[scope.variation];
                            variationData.crop_x = parseInt(data.x, 10);
                            variationData.crop_y = parseInt(data.y, 10);
                            variationData.crop_width = parseInt(data.w, 10);
                            variationData.crop_height = parseInt(data.h, 10);
                            scope.selected({
                                'x': parseInt(data.x, 10),
                                'y': parseInt(data.y, 10),
                                'width': parseInt(data.w, 10),
                                'height': parseInt(data.h, 10),
                                'code': scope.variation
                            });
                        }
                        firstTry = false;
                    }
                }, function () {
                    scope.cropApi = this;
                });
            }

        }
    };
});
